/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileDeleteTemplate;
import com.kwoksys.action.files.FileEditTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.hardware.dto.HardwareFile;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class HardwareFileAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "FILES_ORDER_BY", "file_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "FILES_ORDER", "asc");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        String fileDownloadPath = AppPaths.HARDWARE_FILE_DOWNLOAD + "?hardwareId=" + hardwareId + "&fileId=";
        String fileDeletePath = AppPaths.HARDWARE_FILE_DELETE + "?hardwareId=" + hardwareId + "&fileId=";
        String fileEditPath = AppPaths.HARDWARE_FILE_EDIT + "?hardwareId=" + hardwareId + "&fileId=";
        boolean canDeleteFile = user.hasPermission(AppPaths.HARDWARE_FILE_DELETE);
        boolean canDownloadFile = user.hasPermission(AppPaths.HARDWARE_FILE_DOWNLOAD);
        QueryCriteria queryCriteria = new QueryCriteria();
        if (FileUtils.isSortableColumn(orderBy)) {
            queryCriteria.addSortColumn(FileQueries.getOrderByColumn(orderBy), order);
        }
        List<File> fileList = hardwareService.getHardwareFiles(queryCriteria, hardware.getId());
        ArrayList<String> columnHeaders = new ArrayList<String>(FileUtils.getFileColumnHeaders());
        if (canDeleteFile) {
            columnHeaders.add("command");
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, headerTemplate, hardwareId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        if (user.hasPermission(AppPaths.HARDWARE_FILE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setTitleKey("files.fileAttach");
            if (fileService.isDirectoryExist(ConfigManager.file.getHardwareFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.HARDWARE_FILE_ADD + "?hardwareId=" + hardwareId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            headerTemplate.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("fileTab");
        TableTemplate tableHeader = standardTemplate.addTemplate(new TableTemplate());
        tableHeader.setColumnPath(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
        tableHeader.setColumnHeaders(columnHeaders);
        tableHeader.setColumnTextKey("files.colName.");
        tableHeader.setSortableColumnHeaders(FileUtils.getSortableColumns());
        tableHeader.setOrderBy(orderBy);
        tableHeader.setOrder(order);
        tableHeader.setEmptyRowMsgKey("files.noAttachments");
        if (!fileList.isEmpty()) {
            Counter counter = new Counter();
            for (File file : fileList) {
                ArrayList<String> columns = new ArrayList<String>();
                columns.add(counter.incr() + ".");
                columns.add(Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), fileDownloadPath + file.getId()).getString());
                columns.add(HtmlUtils.encode(file.getTitle()));
                columns.add(file.getCreationDate());
                columns.add(FileUtils.formatFileSize(this.requestContext, file.getSize()));
                if (canDeleteFile) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(new Link(this.requestContext).setAjaxPath(fileEditPath + file.getId()).setTitleKey("common.action.Edit").getString());
                    sb.append(" | ");
                    sb.append(new Link(this.requestContext).setAjaxPath(fileDeletePath + file.getId()).setTitleKey("common.action.Delete").getString());
                    columns.add(sb.toString());
                }
                tableHeader.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        FileUploadForm fileUploadForm = this.getBaseForm(FileUploadForm.class);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(fileUploadForm));
        fileAdd.setFileName(fileUploadForm.getFileName0());
        fileAdd.setFormAction(AppPaths.HARDWARE_FILE_ADD_2 + "?hardwareId=" + hardwareId);
        fileAdd.setFormCancelAction(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
        ActionErrorsTemplate errorsTemplate = fileAdd.getErrorsTemplate();
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        HardwareFile file = new HardwareFile(hardwareId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.addFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.HARDWARE_FILE_ADD + "?hardwareId=" + hardware.getId() + "&" + "_error=true");
        }
        hardwareService.resetHardwareFileCount(hardware.getId());
        return this.redirect(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardware.getId());
    }

    public String edit() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = hardwareService.getHardwareFile(hardwareId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        FileEditTemplate fileEdit = standardTemplate.addTemplate(new FileEditTemplate());
        fileEdit.setFile(file);
        fileEdit.setFormAction(AppPaths.HARDWARE_FILE_EDIT_2 + "?hardwareId=" + hardwareId + "&fileId=" + fileId);
        fileEdit.setFormCancelAction(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
        ActionErrorsTemplate errorsTemplate = fileEdit.getErrorsTemplate();
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String edit2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = hardwareService.getHardwareFile(hardware.getId(), fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.updateFile(file, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_FILE_EDIT + "?hardwareId=" + hardware.getId() + "&fileId=" + fileId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
    }

    public String delete() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = hardwareService.getHardwareFile(hardwareId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hardwareId", hardwareId);
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        FileDeleteTemplate fileDelete = standardTemplate.addTemplate(new FileDeleteTemplate());
        fileDelete.setFile(file);
        fileDelete.setFormAction(AppPaths.HARDWARE_FILE_DELETE_2 + "?hardwareId=" + hardwareId + "&fileId=" + file.getId());
        fileDelete.setFormCancelAction(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = hardwareService.getHardwareFile(hardware.getId(), fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ActionMessages errors = fileService.deleteFile(file);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_FILE_DELETE + "?hardwareId=" + hardware.getId() + "&fileId=" + fileId + "&" + "_error=true");
        }
        hardwareService.resetHardwareFileCount(hardwareId);
        return this.ajaxUpdateView(AppPaths.HARDWARE_FILE + "?hardwareId=" + hardwareId);
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        try {
            HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
            hardwareService.getHardware(hardwareId);
            Integer fileId = this.requestContext.getParameter("fileId");
            File file = hardwareService.getHardwareFile(hardwareId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }
}

