/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.hardware.HardwareForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.action.issues.IssueAssociateTemplate;
import com.kwoksys.action.issues.IssueListTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.dto.linking.HardwareIssueLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;

public class HardwareIssueAction
extends Action2 {
    public String list() throws Exception {
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        AccessUser user = this.requestContext.getUser();
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(HardwareQueries.getOrderByColumn("creation_date"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, headerTemplate, hardware.getId());
        if (Access.hasPermission(user, AppPaths.HARDWARE_ISSUE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_ISSUE_ADD + "?hardwareId=" + hardware.getId());
            link.setTitleKey("common.linking.linkIssue");
            headerTemplate.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("issueTab");
        IssueListTemplate listTemplate = standardTemplate.addTemplate(new IssueListTemplate());
        listTemplate.setAccessUser(user);
        listTemplate.setQueryCriteria(queryCriteria);
        listTemplate.setObjectMap(new HardwareIssueLink(hardware.getId()).createObjectMap());
        listTemplate.setFormRemoveItemAction(AppPaths.HARDWARE_ISSUE_REMOVE_2);
        listTemplate.setColumnHeaders(IssueUtils.getIssueColumnHeaders());
        listTemplate.setEmptyTableRowKey("issueMgmt.issueList.emptyTableMessage");
        listTemplate.getFormHiddenVariableMap().put("hardwareId", String.valueOf(hardware.getId()));
        listTemplate.setFormRowIdName("issueId");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        HardwareForm actionForm = this.getBaseForm(HardwareForm.class);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hardwareId", hardware.getId());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        IssueAssociateTemplate issueAdd = standardTemplate.addTemplate(new IssueAssociateTemplate());
        issueAdd.setIssueId(actionForm.getIssueId());
        issueAdd.setLinkedObjectTypeId(ObjectTypes.HARDWARE);
        issueAdd.setLinkedObjectId(hardware.getId());
        issueAdd.setFormSearchAction(AppPaths.HARDWARE_ISSUE_ADD);
        issueAdd.setFormSaveAction(AppPaths.HARDWARE_ISSUE_ADD_2);
        issueAdd.setFormCancelAction(AppPaths.HARDWARE_ISSUE + "?hardwareId=" + hardware.getId());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        Integer issueId = this.requestContext.getParameter("issueId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        hardwareService.getHardware(hardwareId);
        HardwareIssueLink issueMap = new HardwareIssueLink();
        issueMap.setHardwareId(hardwareId);
        issueMap.setIssueId(issueId);
        ActionMessages errors = hardwareService.addHardwareIssue(issueMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_ISSUE_ADD + "?hardwareId=" + hardwareId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_ISSUE + "?hardwareId=" + hardwareId);
    }

    public String remove2() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        Integer issueId = this.requestContext.getParameter("issueId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        hardwareService.getHardware(hardwareId);
        HardwareIssueLink issueMap = new HardwareIssueLink();
        issueMap.setHardwareId(hardwareId);
        issueMap.setIssueId(issueId);
        ActionMessages errors = hardwareService.deleteHardwareIssue(issueMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_ISSUE + "?" + "_error=true" + "&hardwareId=" + hardwareId);
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_ISSUE + "?hardwareId=" + hardwareId);
    }
}

