/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.AjaxTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.hardware.HardwareSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HardwareListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        String cmd = this.requestContext.getParameterString("cmd");
        if ("autoSuggestList".equals(cmd)) {
            return this.autoSuggestList();
        }
        AccessUser user = this.requestContext.getUser();
        HardwareSearchForm actionForm = this.getSessionBaseForm(HardwareSearchForm.class);
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "HARDWARE_ORDER_BY", "hardware_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "HARDWARE_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("HARDWARE_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "HARDWARE_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getHardwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, "HARDWARE_SEARCH_CRITERIA_MAP");
        hardwareSearch.prepareMap(actionForm);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        Map<Integer, AttributeField> attrFieldTypeMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_TYPE);
        ArrayList<LabelValueBean> hardwareTypeOptions = new ArrayList<LabelValueBean>();
        hardwareTypeOptions.add(new SelectOneLabelValueBean(this.requestContext));
        QueryCriteria typeQuery = new QueryCriteria();
        typeQuery.addSortColumn(HardwareQueries.getOrderByColumn("attribute_field_name"));
        for (AttributeFieldCount hardware : hardwareService.getHardwareTypeCount(typeQuery)) {
            AttributeField attrField = attrFieldTypeMap.get(hardware.getAttrFieldId());
            String hardwareTypeName = attrField == null ? Localizer.getText(this.requestContext, "itMgmt.index.na") : attrField.getName();
            hardwareTypeOptions.add(new LabelValueBean(hardwareTypeName, String.valueOf(hardware.getAttrFieldId())));
        }
        QueryCriteria query = new QueryCriteria(hardwareSearch);
        query.setLimit(rowLimit, rowStart);
        if (HardwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(orderBy), order);
        }
        int rowCount = hardwareService.getHardwareCount(query);
        List<DataRow> dataList = null;
        if (rowCount != 0) {
            List<Hardware> hardwareList = hardwareService.getHardwareList(query);
            dataList = HardwareUtils.formatHardwareList(this.requestContext, hardwareList, new Counter(rowStart), AppPaths.HARDWARE_DETAIL);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        if (!hardwareSearch.getSearchCriteriaMap().isEmpty()) {
            standardTemplate.setAttribute("searchResultText", Localizer.getText(this.requestContext, "itMgmt.hardwareList.searchResult"));
        }
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        standardTemplate.setPathAttribute("formAction", AppPaths.HARDWARE_LIST);
        standardTemplate.setAttribute("hardwareTypeOptions", hardwareTypeOptions);
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(HardwareUtils.getColumnHeaderList());
        tableTemplate.setSortableColumnHeaders(HardwareUtils.getSortableColumns());
        tableTemplate.setColumnPath(AppPaths.HARDWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("itMgmt.hardwareList.emptyTableMessage");
        if (ConfigManager.app.isHardwareBulkDeleteEnabled() && Access.hasPermission(user, AppPaths.HARDWARE_DELETE_2)) {
            tableTemplate.setFormName(HardwareSearchForm.class.getSimpleName());
            tableTemplate.setFormRemoveItemAction(AppPaths.HARDWARE_DELETE_2);
            tableTemplate.setFormRowIdName("hardwareIds");
            tableTemplate.setFormSelectMultipleRows(true);
            tableTemplate.getFormButtons().put("common.action.Delete", "common.form.confirmDelete");
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("itMgmt.hardwareList.title");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.HARDWARE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_ADD);
            link.setTitleKey("itMgmt.cmd.hardwareAdd");
            header.addHeaderCmds(link);
        }
        if (user.hasPermission(AppPaths.HARDWARE_LIST_EXPORT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.HARDWARE_LIST_EXPORT + "?rowCmd=" + rowCmd + "&rowStart=" + rowStart);
            link.setTitleKey("itMgmt.cmd.hardwareListExport");
            link.setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "itMgmt.hardwareList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.HARDWARE_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.HARDWARE_LIST + "?rowStart=");
        return standardTemplate.findTemplate("standard_template");
    }

    public String autoSuggestList() throws Exception {
        AccessUser user = this.requestContext.getUser();
        String searchType = this.requestContext.getParameterString("searchType");
        String searchPhrase = this.requestContext.getParameterString("searchPhrase");
        HardwareSearchForm actionForm = new HardwareSearchForm();
        actionForm.setCmd("autoSuggestList");
        HardwareSearch hardwareSearch = new HardwareSearch();
        if (searchType.equals("hardwareId")) {
            actionForm.setHardwareId(searchPhrase);
        } else if (searchType.equals("hardwareName")) {
            actionForm.setHardwareNameCriteria("begins");
            actionForm.setHardwareName(searchPhrase);
        }
        hardwareSearch.prepareMap(actionForm);
        QueryCriteria queryCriteria = new QueryCriteria(hardwareSearch);
        queryCriteria.setLimit(10, 0);
        queryCriteria.addSortColumn("hardware_name", "asc");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        List<Hardware> hardwareDataset = hardwareService.getHardwareList(queryCriteria);
        ArrayList hardwareList = new ArrayList();
        if (!hardwareDataset.isEmpty()) {
            boolean hasHardwareAccess = Access.hasPermission(user, AppPaths.HARDWARE_DETAIL);
            for (Hardware memberHardware : hardwareDataset) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("hardwareId", String.valueOf(memberHardware.getId()));
                Link hardwareLink = new Link(this.requestContext);
                hardwareLink.setTitle(memberHardware.getName());
                if (hasHardwareAccess) {
                    hardwareLink.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + memberHardware.getId());
                }
                map.put("hardwareName", hardwareLink.getString());
                hardwareList.add(map);
            }
            this.request.setAttribute("hardwareList", hardwareList);
        }
        AjaxTemplate ajaxTemplate = new AjaxTemplate(this.requestContext, "autoSuggestList");
        return ajaxTemplate.findTemplate("ajax_template");
    }
}

