/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TableHeaderTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.hardware.HardwareListTemplate;
import com.kwoksys.action.hardware.HardwareMemberForm;
import com.kwoksys.action.hardware.HardwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.linking.HardwareMemberLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;

public class HardwareMemberAction
extends Action2 {
    public String list() throws Exception {
        this.getBaseForm(HardwareMemberForm.class);
        AccessUser user = this.requestContext.getUser();
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(hardwareId);
        String moOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "moOrderBy", "HARDWARE_MEMBER_OF_ORDER_BY", "hardware_name");
        String moOrder = SessionManager.getOrSetAttribute(this.requestContext, "moOrder", "HARDWARE_MEMBER_OF_ORDER", "asc");
        String mOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "mOrderBy", "HARDWARE_MEMBER_ORDER_BY", "hardware_name");
        String mOrder = SessionManager.getOrSetAttribute(this.requestContext, "mOrder", "HARDWARE_MEMBER_ORDER", "asc");
        boolean canRemoveHardware = Access.hasPermission(user, AppPaths.HARDWARE_MEMBER_REMOVE_2);
        ArrayList<String> hwColumnHeaders = new ArrayList<String>();
        if (canRemoveHardware) {
            hwColumnHeaders.add("");
        }
        hwColumnHeaders.addAll(HardwareUtils.getColumnHeaderList());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formRemoveHardwareAction", AppPaths.HARDWARE_MEMBER_REMOVE_2);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        HardwareUtils.addHardwareHeaderCommands(this.requestContext, headerTemplate, hardwareId);
        if (Access.hasPermission(user, AppPaths.HARDWARE_MEMBER_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.HARDWARE_MEMBER_ADD + "?hardwareId=" + hardwareId);
            link.setTitleKey("hardware.cmd.hardwareMemberAdd");
            headerTemplate.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(HardwareUtils.hardwareTabList(hardware, this.requestContext));
        tabs.setTabActive("memberTab");
        TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate("_memberOf"));
        empty.setColSpan(HardwareUtils.getColumnHeaderList().size());
        empty.setRowText(Localizer.getText(this.requestContext, "hardware.members.emptyMemberOfMessage"));
        TableHeaderTemplate tableHeader = standardTemplate.addTemplate(new TableHeaderTemplate("_memberOf"));
        tableHeader.setColumnList(HardwareUtils.getColumnHeaderList());
        tableHeader.setSortableColumnList(HardwareUtils.getSortableColumns());
        tableHeader.setColumnPath(AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardwareId);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setOrderBy(moOrderBy);
        tableHeader.setOrderByParamName("moOrderBy");
        tableHeader.setOrder(moOrder);
        tableHeader.setOrderParamName("moOrder");
        QueryCriteria query = new QueryCriteria();
        if (HardwareUtils.isSortableColumn(moOrderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(moOrderBy), moOrder);
        }
        HardwareListTemplate listTemplate = standardTemplate.addTemplate(new HardwareListTemplate("_memberOf"));
        listTemplate.setHardwareList(hardwareService.getHardwareParents(query, hardwareId));
        listTemplate.setHardwarePath(AppPaths.HARDWARE_MEMBER);
        listTemplate.setColspan(HardwareUtils.getColumnHeaderList().size());
        listTemplate.setListHeader("hardware.members.header.memberOf");
        listTemplate.getFormHiddenVariableMap().put("hardwareId", String.valueOf(hardware.getId()));
        empty = standardTemplate.addTemplate(new TableEmptyTemplate("_members"));
        empty.setColSpan(hwColumnHeaders.size());
        empty.setRowText(Localizer.getText(this.requestContext, "hardware.members.emptyMemberMessage"));
        tableHeader = standardTemplate.addTemplate(new TableHeaderTemplate("_members"));
        tableHeader.setColumnList(hwColumnHeaders);
        tableHeader.setSortableColumnList(HardwareUtils.getSortableColumns());
        tableHeader.setColumnPath(AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardwareId);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setOrderBy(mOrderBy);
        tableHeader.setOrderByParamName("mOrderBy");
        tableHeader.setOrder(mOrder);
        tableHeader.setOrderParamName("mOrder");
        query = new QueryCriteria();
        if (HardwareUtils.isSortableColumn(mOrderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(mOrderBy), mOrder);
        }
        listTemplate = standardTemplate.addTemplate(new HardwareListTemplate("_members"));
        listTemplate.setHardwareList(hardwareService.getHardwareMembers(query, hardwareId));
        listTemplate.setHardwarePath(AppPaths.HARDWARE_MEMBER);
        listTemplate.setCanRemoveHardware(canRemoveHardware);
        listTemplate.setColspan(hwColumnHeaders.size());
        listTemplate.getFormHiddenVariableMap().put("hardwareId", String.valueOf(hardware.getId()));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String add() throws Exception {
        HardwareMemberForm actionForm = this.getBaseForm(HardwareMemberForm.class);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        Hardware hardware = hardwareService.getHardware(actionForm.getHardwareId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext, "add");
        standardTemplate.setAttribute("hardwareId", hardware.getId());
        standardTemplate.setPathAttribute("formSearchAction", AppPaths.HARDWARE_LIST_SELECT);
        standardTemplate.setPathAttribute("formSaveAction", AppPaths.HARDWARE_MEMBER_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardware.getId()).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.hardwareDetail.header", new Object[]{hardware.getName()});
        standardTemplate.addTemplate(new HardwareSpecTemplate(hardware));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        HardwareMemberForm actionForm = this.getBaseForm(HardwareMemberForm.class);
        Integer hardwareId = actionForm.getHardwareId();
        Integer formHardwareId = actionForm.getFormSelectedHardwareId();
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        hardwareService.getHardware(hardwareId);
        HardwareMemberLink memberMap = new HardwareMemberLink();
        memberMap.setHardwareId(hardwareId);
        memberMap.setMemberHardwareId(formHardwareId);
        ActionMessages errors = hardwareService.addHardwareMember(memberMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_MEMBER_ADD + "?hardwareId=" + hardwareId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardwareId);
    }

    public String remove() throws Exception {
        Integer hardwareId = this.requestContext.getParameter("hardwareId");
        Integer formHardwareId = this.requestContext.getParameter("formHardwareId");
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        hardwareService.getHardware(hardwareId);
        HardwareMemberLink memberMap = new HardwareMemberLink();
        memberMap.setHardwareId(hardwareId);
        memberMap.setMemberHardwareId(formHardwareId);
        ActionMessages errors = hardwareService.removeHardwareMember(memberMap);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.HARDWARE_MEMBER + "?" + "_error=true" + "&hardwareId=" + hardwareId);
        }
        return this.ajaxUpdateView(AppPaths.HARDWARE_MEMBER + "?hardwareId=" + hardwareId);
    }
}

