/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HardwareSearchTemplate
extends BaseTemplate {
    private String formAction;
    private List<AttributeFieldCount> hardwareTypeData;
    private List<AttributeFieldCount> hardwareStatusData;
    private List<AttributeFieldCount> hardwareLocationData;
    private boolean hideSearchButton;
    private String clearSearchLink;

    public HardwareSearchTemplate() {
        super(HardwareSearchTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        List<LabelValueBean> nameCriteriaOptions = Arrays.asList(new LabelValueBean(Localizer.getText(this.requestContext, "core.search.criteria.exactMatch"), "equals"), new LabelValueBean(Localizer.getText(this.requestContext, "core.search.criteria.contains"), "contains"), new LabelValueBean(Localizer.getText(this.requestContext, "core.search.criteria.beginsWith"), "begins"));
        ArrayList<LabelValueBean> companyOptions = new ArrayList<LabelValueBean>();
        companyOptions.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        companyOptions.addAll(CompanyUtils.getCompanyOptions(this.requestContext));
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(HardwareQueries.getOrderByColumn("attribute_field_name"));
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        Map<Integer, AttributeField> attrFieldTypeMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_TYPE);
        Map<Integer, AttributeField> attrFieldStatusMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_STATUS);
        Map<Integer, AttributeField> attrFieldLocMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_LOCATION);
        ArrayList<LabelValueBean> hardwareTypeOptions = new ArrayList<LabelValueBean>();
        hardwareTypeOptions.add(new SelectOneLabelValueBean(this.requestContext));
        if (this.hardwareTypeData == null) {
            this.hardwareTypeData = hardwareService.getHardwareTypeCount(query);
        }
        for (AttributeFieldCount attributeFieldCount : this.hardwareTypeData) {
            AttributeField attributeField = attrFieldTypeMap.get(attributeFieldCount.getAttrFieldId());
            String hardwareTypeName = attributeField != null ? attributeField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            hardwareTypeOptions.add(new LabelValueBean(hardwareTypeName, String.valueOf(attributeFieldCount.getAttrFieldId())));
        }
        ArrayList<LabelValueBean> statusOptions = new ArrayList<LabelValueBean>();
        statusOptions.add(new SelectOneLabelValueBean(this.requestContext));
        if (this.hardwareStatusData == null) {
            this.hardwareStatusData = hardwareService.getHardwareStatusCount(query);
        }
        for (AttributeFieldCount attributeFieldCount : this.hardwareStatusData) {
            AttributeField attrField = attrFieldStatusMap.get(attributeFieldCount.getAttrFieldId());
            String hardwareStatusName = attrField != null ? attrField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            statusOptions.add(new LabelValueBean(hardwareStatusName, String.valueOf(attributeFieldCount.getAttrFieldId())));
        }
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        arrayList.add(new SelectOneLabelValueBean(this.requestContext));
        if (this.hardwareLocationData == null) {
            this.hardwareLocationData = hardwareService.getHardwareLocationCount(query);
        }
        for (AttributeFieldCount hardware : this.hardwareLocationData) {
            AttributeField attrField = attrFieldLocMap.get(hardware.getAttrFieldId());
            String hardwareLocName = attrField != null ? attrField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            arrayList.add(new LabelValueBean(hardwareLocName, String.valueOf(hardware.getAttrFieldId())));
        }
        this.request.setAttribute("hardwareNameCriteriaOptions", nameCriteriaOptions);
        this.request.setAttribute("manufacturersOptions", companyOptions);
        this.request.setAttribute("vendorsOptions", companyOptions);
        this.request.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("yearOptions", CalendarUtils.getPastYearOptions(this.requestContext));
        this.request.setAttribute("hardwareTypeOptions", hardwareTypeOptions);
        this.request.setAttribute("hardwareStatusOptions", statusOptions);
        this.request.setAttribute("hardwareLocationOptions", arrayList);
        this.request.setAttribute("customFieldsOptions", new AttributeManager(this.requestContext).getCustomFieldOptions(ObjectTypes.HARDWARE));
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, "HARDWARE_SEARCH_CRITERIA_MAP");
        ArrayList warrantyOptions = new ArrayList();
        for (String key : new String[]{"warrantyExpired", "warrantyNotExpired", "warrantyNotSet"}) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("key", key);
            map.put("checked", hardwareSearch.getSearchCriteriaMap().containsKey(key) ? "checked" : "");
            warrantyOptions.add(map);
        }
        this.request.setAttribute("warrantyOptions", warrantyOptions);
        this.request.setAttribute("componentTypeOptions", new AttributeManager(this.requestContext).setOptional(true).getAttrFieldOptionsCache(Attributes.HARDWARE_COMPONENT_TYPE));
        if (!this.hideSearchButton) {
            this.clearSearchLink = new Link(this.requestContext).setAjaxPath(AppPaths.HARDWARE_INDEX + "?cmd=clear").setTitleKey("common.form.clearCriteria").getString();
        }
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public void setHardwareTypeData(List<AttributeFieldCount> hardwareTypeData) {
        this.hardwareTypeData = hardwareTypeData;
    }

    public void setHardwareStatusData(List<AttributeFieldCount> hardwareStatusData) {
        this.hardwareStatusData = hardwareStatusData;
    }

    public void setHardwareLocationData(List<AttributeFieldCount> hardwareLocationData) {
        this.hardwareLocationData = hardwareLocationData;
    }

    public boolean getHideSearchButton() {
        return this.hideSearchButton;
    }

    public void setHideSearchButton(boolean hideSearchButton) {
        this.hideSearchButton = hideSearchButton;
    }

    public String getClearSearchLink() {
        return this.clearSearchLink;
    }
}

