/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.contracts.dao.ContractQueries;
import com.kwoksys.biz.contracts.dto.Contract;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.Callback;
import com.kwoksys.framework.util.CurrencyUtils;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class HardwareSpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private Hardware hardware;
    private boolean populateLinkedContract;
    private int columns = 2;
    private boolean disableHeader;
    private String headerText;
    private StringBuilder contracts;

    public HardwareSpecTemplate(Hardware hardware) {
        super(HardwareSpecTemplate.class);
        this.hardware = hardware;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        this.detailTableTemplate.setNumColumns(this.columns);
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_id");
        td.setValue(String.valueOf(this.hardware.getId()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_name");
        td.setValue(HtmlUtils.encode(this.hardware.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.hardware.getDescription()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_manufacturer_name");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.hardware.getManufacturerName(), this.hardware.getManufacturerId()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_vendor_name");
        td.setValue(Links.getCompanyDetailsLink(this.requestContext, this.hardware.getVendorName(), this.hardware.getVendorId()).getString());
        AttributeField attrField = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_TYPE).get(this.hardware.getType());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_type");
        td.setValue(Links.getAttrFieldIcon(this.requestContext, attrField).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_status");
        td.setValue(HtmlUtils.encode(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_STATUS, this.hardware.getStatus())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_model_name");
        td.setValue(HtmlUtils.encode(this.hardware.getModelName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_model_number");
        td.setValue(HtmlUtils.encode(this.hardware.getModelNumber()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_serial_number");
        td.setValue(HtmlUtils.encode(this.hardware.getSerialNumber()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_purchase_price");
        td.setValue(CurrencyUtils.formatCurrency(this.hardware.getPurchasePriceRaw(), ConfigManager.system.getCurrencySymbol()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_purchase_date");
        td.setValue(DatetimeUtils.toShortDate(this.hardware.getHardwarePurchaseDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_warranty_expire_date");
        td.setValue(HardwareUtils.formatWarrantyExpirationDate(this.requestContext, this.requestContext.getSysdate(), this.hardware.getWarrantyExpireDate()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_last_service_date");
        td.setValue(this.hardware.getLastServicedOn());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_location");
        td.setValue(HtmlUtils.encode(attributeManager.getAttrFieldNameCache(Attributes.HARDWARE_LOCATION, this.hardware.getLocation())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.hardware_owner_name");
        boolean canViewUserPage = Access.hasPermission(accessUser, AppPaths.ADMIN_USER_DETAIL);
        AccessUser hardwareOwner = new CacheManager(this.requestContext).getUserCache(this.hardware.getOwnerId());
        td.setValue(Links.getUserIconLink(this.requestContext, hardwareOwner, canViewUserPage, true).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.hardware.getCreationDate(), this.hardware.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.hardware.getModificationDate(), this.hardware.getModifier()));
        if (this.populateLinkedContract) {
            final boolean canViewContract = Access.hasPermission(accessUser, AppPaths.CONTRACTS_DETAIL);
            HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
            this.contracts = new StringBuilder();
            QueryCriteria queryCriteria = new QueryCriteria();
            queryCriteria.addSortColumn(ContractQueries.getOrderByColumn("contract_name"));
            queryCriteria.setCallback(new Callback(){

                @Override
                public void run(Object object) throws Exception {
                    Contract contract = (Contract)object;
                    Link link = new Link(HardwareSpecTemplate.this.requestContext);
                    link.setTitle(contract.getName());
                    if (canViewContract) {
                        link.setAjaxPath(AppPaths.CONTRACTS_DETAIL + "?contractId=" + contract.getId());
                    }
                    if (HardwareSpecTemplate.this.contracts.length() != 0) {
                        HardwareSpecTemplate.this.contracts.append(", ");
                    }
                    HardwareSpecTemplate.this.contracts.append(link.getString());
                }
            });
            hardwareService.fetchLinkedContracts(queryCriteria, this.hardware.getId());
        }
        this.headerText = Localizer.getText(this.requestContext, "itMgmt.hardwareDetail.header", (Object[])new String[]{this.hardware.getName()});
    }

    @Override
    public String getJspPath() {
        return "/jsp/hardware/HardwareSpecTemplate.jsp";
    }

    public void setPopulateLinkedContract(boolean populateLinkedContract) {
        this.populateLinkedContract = populateLinkedContract;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setDisableHeader(boolean disableHeader) {
        this.disableHeader = disableHeader;
    }

    public boolean isDisableHeader() {
        return this.disableHeader;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public String getContracts() {
        if (this.contracts == null) {
            return "";
        }
        return this.contracts.toString();
    }
}

