/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.hardware;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.hardware.HardwareSearchForm;
import com.kwoksys.action.hardware.HardwareSearchTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.ChartJsColors;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        HttpSession session = this.request.getSession();
        if (this.requestContext.getParameterString("cmd").equals("clear")) {
            session.setAttribute("HARDWARE_SEARCH_CRITERIA_MAP", null);
            this.clearSessionBaseForm(HardwareSearchForm.class);
        }
        this.getSessionBaseForm(HardwareSearchForm.class);
        ArrayList<Link> links = new ArrayList<Link>();
        if (user.hasPermission(AppPaths.HARDWARE_LIST)) {
            if (session.getAttribute("HARDWARE_SEARCH_CRITERIA_MAP") != null) {
                links.add(new Link(this.requestContext).setTitleKey("common.search.showLastSearch").setAjaxPath(AppPaths.HARDWARE_LIST));
            }
            links.add(new Link(this.requestContext).setTitleKey("itMgmt.index.showAllHardware").setAjaxPath(AppPaths.HARDWARE_LIST + "?cmd=showAll"));
        }
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        int numHardwareRecords = hardwareService.getHardwareCount(new QueryCriteria());
        ArrayList<String> warrantyExpirationLinks = new ArrayList<String>();
        for (Map.Entry<String, String> entry : hardwareService.getWarrantyExpirationCounts().entrySet()) {
            if (NumberUtils.replaceNull(entry.getValue()) <= 0) continue;
            warrantyExpirationLinks.add(new Link(this.requestContext).setAjaxPath(AppPaths.HARDWARE_LIST + "?cmd=groupBy&warrantyExpire=" + entry.getKey()).setTitle(Localizer.getText(this.requestContext, "contracts.search.expire_" + entry.getKey()) + " (" + entry.getValue() + ")").getString());
        }
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(HardwareQueries.getOrderByColumn("attribute_field_name"));
        Map<Integer, AttributeField> attrFieldTypeMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_TYPE);
        Map<Integer, AttributeField> attrFieldStatusMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_STATUS);
        Map<Integer, AttributeField> attrFieldLocMap = attributeManager.getAttrFieldMapCache(Attributes.HARDWARE_LOCATION);
        ArrayList hardwareTypeCounts = new ArrayList();
        List<AttributeFieldCount> hardwareTypeData = hardwareService.getHardwareTypeCount(query);
        ChartJsColors chartJsColors = new ChartJsColors();
        for (AttributeFieldCount hardware : hardwareTypeData) {
            AttributeField attrField = attrFieldTypeMap.get(hardware.getAttrFieldId());
            String chartHardwareLabel = attrField != null ? attrField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            String hardwareTypeName = attrField != null ? Links.getAttrFieldIcon(this.requestContext, attrField).getString() : chartHardwareLabel;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("countKey", hardwareTypeName);
            map.put("countValue", String.valueOf(hardware.getObjectCount()));
            map.put("path", AppPaths.ROOT + AppPaths.HARDWARE_LIST + "?cmd=groupBy&hardwareType=" + hardware.getAttrFieldId());
            map.put("chartLabel", StringUtils.encodeJavascript(chartHardwareLabel));
            map.put("color", chartJsColors.getColor());
            chartJsColors.incrCount();
            hardwareTypeCounts.add(map);
        }
        ArrayList hardwareStatusCounts = new ArrayList();
        List<AttributeFieldCount> hardwareStatusData = hardwareService.getHardwareStatusCount(query);
        for (AttributeFieldCount hardware : hardwareStatusData) {
            AttributeField attrField = attrFieldStatusMap.get(hardware.getAttrFieldId());
            String hardwareStatusName = attrField != null ? attrField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("countKey", hardwareStatusName);
            map.put("countValue", String.valueOf(hardware.getObjectCount()));
            map.put("path", AppPaths.ROOT + AppPaths.HARDWARE_LIST + "?cmd=groupBy&hardwareStatus=" + hardware.getAttrFieldId());
            map.put("chartLabel", StringUtils.encodeJavascript(hardwareStatusName));
            map.put("color", chartJsColors.getColor());
            chartJsColors.incrCount();
            hardwareStatusCounts.add(map);
        }
        ArrayList locationCounts = new ArrayList();
        List<AttributeFieldCount> hardwareLocationData = hardwareService.getHardwareLocationCount(query);
        for (AttributeFieldCount hardware : hardwareLocationData) {
            AttributeField attrField = attrFieldLocMap.get(hardware.getAttrFieldId());
            String hardwareLocName = attrField != null ? attrField.getName() : Localizer.getText(this.requestContext, "itMgmt.index.na");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("countKey", hardwareLocName);
            map.put("countValue", String.valueOf(hardware.getObjectCount()));
            map.put("path", AppPaths.ROOT + AppPaths.HARDWARE_LIST + "?cmd=groupBy&hardwareLocation=" + hardware.getAttrFieldId());
            map.put("chartLabel", StringUtils.encodeJavascript(hardwareLocName));
            map.put("color", chartJsColors.getColor());
            chartJsColors.incrCount();
            locationCounts.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("linkList", links);
        standardTemplate.setAttribute("hardwareTypeCountList", hardwareTypeCounts);
        standardTemplate.setAttribute("hardwareStatusCounts", hardwareStatusCounts);
        standardTemplate.setAttribute("hardwareLocationCountList", locationCounts);
        standardTemplate.setAttribute("warrantyExpirationLinks", warrantyExpirationLinks);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("core.moduleName.1");
        header.setTitleClassNoLine();
        header.setSectionKey("itMgmt.hardwareIndex.numRecords", new Integer[]{numHardwareRecords});
        if (user.hasPermission(AppPaths.HARDWARE_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("itMgmt.cmd.hardwareAdd").setAjaxPath(AppPaths.HARDWARE_ADD));
        }
        HardwareSearchTemplate searchTemplate = standardTemplate.addTemplate(new HardwareSearchTemplate());
        searchTemplate.setFormAction(AppPaths.HARDWARE_LIST);
        searchTemplate.setHardwareTypeData(hardwareTypeData);
        searchTemplate.setHardwareStatusData(hardwareStatusData);
        searchTemplate.setHardwareLocationData(hardwareLocationData);
        return standardTemplate.findTemplate("standard_template");
    }
}

