/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.home;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.home.IndexForm;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessage;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.NumberUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        String requestLocale = this.requestContext.getParameterString("locale");
        String errorCode = this.requestContext.getParameterString("errorCode");
        String fontSize = this.requestContext.getParameterString("fontSize");
        HttpSession session = this.request.getSession();
        IndexForm actionForm = this.getBaseForm(IndexForm.class);
        actionForm.setPassword("");
        if (!requestLocale.isEmpty()) {
            Localizer.setSessionLocale(session, requestLocale);
        }
        actionForm.setLocale(this.requestContext.getLocale().toString());
        SessionManager.setAppSessionTheme(session, actionForm.getTheme());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAdEnabled(false);
        standardTemplate.setPathAttribute("formLoginAction", AppPaths.AUTH_VERIFY);
        standardTemplate.setPathAttribute("formAction", AppPaths.HOME_INDEX);
        standardTemplate.setAttribute("isUserLoggedOn", user.isLoggedOn());
        standardTemplate.setAttribute("domain", ConfigManager.auth.getAuthDomain());
        standardTemplate.setAttribute("localeOptions", WidgetUtils.getLocaleOptions(this.requestContext));
        ArrayList<String> themeLinks = new ArrayList<String>();
        for (String theme : ConfigManager.system.getThemeOptions()) {
            themeLinks.add(new Link(this.requestContext).setAppPath(AppPaths.HOME_INDEX + "?theme=" + theme).setTitleKey("admin.config.theme." + theme).getString());
        }
        standardTemplate.setAttribute("themeLinks", themeLinks);
        ArrayList<String> fontLinks = new ArrayList<String>();
        for (int fontOption : ConfigManager.system.getFontOptions()) {
            fontLinks.add(new Link(this.requestContext).setAppPath(AppPaths.HOME_INDEX + "?fontSize=" + fontOption).setTitle(String.valueOf(fontOption)).getString());
        }
        standardTemplate.setAttribute("fontLinks", fontLinks);
        standardTemplate.setAttribute("homeCustomDescription", ConfigManager.system.getCustomHomeDescription());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (!fontSize.isEmpty() && NumberUtils.isInteger(fontSize)) {
            this.request.getSession().setAttribute("FONT_SIZE", (Object)fontSize);
            header.setFontSize(fontSize);
        }
        if (user.isLoggedOn()) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            standardTemplate.setAttribute("user", userMap);
            userMap.put("username", user.getUsername());
            userMap.put("displayName", user.getDisplayName());
            userMap.put("email", HtmlUtils.formatMailtoLink(user.getEmail()));
            userMap.put("creationDate", user.getCreationDate());
        } else {
            if (!actionForm.isResubmit()) {
                actionForm.setUsername("");
                actionForm.setDomain(null);
            }
            ArrayList<LabelValueBean> domainOptions = new ArrayList<LabelValueBean>();
            for (String domain : ConfigManager.auth.getAuthDomainOptions()) {
                domainOptions.add(new LabelValueBean(domain.trim(), domain.trim()));
            }
            if (!ConfigManager.auth.getAuthDomainOptions().isEmpty() && !ConfigManager.auth.getAuthMethod().equals("ldap")) {
                domainOptions.add(new SelectOneLabelValueBean(this.requestContext));
            }
            standardTemplate.setAttribute("domainOptions", domainOptions);
            if (!errorCode.isEmpty()) {
                ActionMessages errors = new ActionMessages();
                errors.add(errorCode, new ActionMessage("auth.login.error." + errorCode));
                this.saveActionErrors(errors);
            }
            standardTemplate.getHeaderTemplate().setOnloadJavascript("App.focusLogin(document.loginForm.username, document.loginForm.password);");
        }
        standardTemplate.addTemplate(new ActionErrorsTemplate().setHideErrorTitle(true));
        return standardTemplate.findTemplate("standard_template");
    }
}

