/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issueplugin;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.issues.IssueForm;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Schema;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;

public class IssueAddAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        IssueForm actionForm = this.getBaseForm(IssueForm.class);
        actionForm.setId("issueAddForm");
        Issue issue = new Issue();
        if (!actionForm.isResubmit()) {
            actionForm.setIssueName("");
            actionForm.setDescription("");
            actionForm.setType(issue.getType());
            actionForm.setPriority(issue.getPriority());
        }
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn("attribute_field_name");
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ISSUE_PLUGIN_ADD_2);
        this.request.setAttribute("legendLink", (Object)new Link(this.requestContext).setInlineImage(Image.getInstance().getHelp(Localizer.getText(this.requestContext, "issuePlugin.issueAdd.notation"))).setJavascript("window.open('" + AppPaths.ROOT + AppPaths.ISSUE_PLUGIN_LEGEND_DETAIL + "?attributeId=" + Attributes.ISSUE_TYPE + "', 'legend', 'width=480, height=420, left=50, top=50, scrollbars=yes, resizable=yes')"));
        this.request.setAttribute("issueNameCharLimit", (Object)Schema.getColumnLength("issue.issue_name"));
        this.request.setAttribute("issueDescriptionCharLimit", (Object)Schema.getColumnLength("issue.issue_description"));
        this.request.setAttribute("typeOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.ISSUE_TYPE));
        this.request.setAttribute("priorityOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.ISSUE_PRIORITY));
        if (accessUser.isLoggedOn()) {
            this.request.setAttribute("createdBy", (Object)AdminUtils.getSystemUsername(this.requestContext, accessUser));
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("issuePlugin.issueAdd.title");
        header.setTitleKey("issuePlugin.issueAdd.title");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("issuePlugin.issueAdd.confirm");
        return standardTemplate.findTemplate("standard_template");
    }
}

