/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.issues.IssueSearchForm;
import com.kwoksys.action.issues.IssueSearchTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.AttributeField;
import com.kwoksys.biz.admin.dto.AttributeFieldCount;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        HttpSession session = this.request.getSession();
        if (this.requestContext.getParameterString("cmd").equals("clear")) {
            session.setAttribute("ISSUE_SEARCH_CRITERIA_MAP", null);
            this.clearSessionBaseForm(IssueSearchForm.class);
        }
        this.getSessionBaseForm(IssueSearchForm.class);
        boolean canViewAllIssues = accessUser.hasPermission(1);
        ArrayList<Link> links = new ArrayList<Link>();
        if (session.getAttribute("ISSUE_SEARCH_CRITERIA_MAP") != null) {
            links.add(new Link(this.requestContext).setTitleKey("common.search.showLastSearch").setAjaxPath(AppPaths.ISSUES_LIST));
        }
        links.add(new Link(this.requestContext).setTitleKey("issueMgmt.index.showNonClosed").setAjaxPath(AppPaths.ISSUES_LIST + "?cmd=showNonClosed"));
        links.add(new Link(this.requestContext).setTitleKey("issueMgmt.index.showOpenUnassigned").setAjaxPath(AppPaths.ISSUES_LIST + "?cmd=showOpenUnassigned"));
        links.add(new Link(this.requestContext).setTitleKey("issueMgmt.index.showMyIssues").setAjaxPath(AppPaths.ISSUES_LIST + "?cmd=showMyIssues"));
        links.add(new Link(this.requestContext).setTitleKey("issueMgmt.index.showMyReportedIssues").setAjaxPath(AppPaths.ISSUES_LIST + "?cmd=showMyReportedIssues"));
        links.add(new Link(this.requestContext).setTitleKey("issueMgmt.index.showAll").setAjaxPath(AppPaths.ISSUES_LIST + "?cmd=showAll"));
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        int numIssueRecords = issueService.getCount(new QueryCriteria());
        IssueSearch issueSearch = new IssueSearch();
        if (!canViewAllIssues) {
            issueSearch.put("issuePermittedUserId", accessUser.getId());
        }
        int numIssuesHasPerm = canViewAllIssues ? numIssueRecords : issueService.getCount(new QueryCriteria(issueSearch));
        ArrayList statusCounts = new ArrayList();
        ArrayList priorityCounts = new ArrayList();
        ArrayList typeCounts = new ArrayList();
        ArrayList assigneeCounts = new ArrayList();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        if (canViewAllIssues) {
            HashMap<String, String> map;
            String path;
            Link countValue;
            Link countKey;
            int count;
            Map<Integer, AttributeField> attrFieldStatusMap = attributeManager.getAttrFieldMapCache(Attributes.ISSUE_STATUS);
            Map<Integer, AttributeField> attrFieldPriorityMap = attributeManager.getAttrFieldMapCache(Attributes.ISSUE_PRIORITY);
            Map<Integer, AttributeField> attrFieldTypeMap = attributeManager.getAttrFieldMapCache(Attributes.ISSUE_TYPE);
            QueryCriteria countsQuery = new QueryCriteria();
            countsQuery.addSortColumn(IssueQueries.getOrderByColumn("attribute_field_name"));
            for (AttributeFieldCount attributeFieldCount : issueService.getGoupByStatusCount(countsQuery)) {
                AttributeField attributeField = attrFieldStatusMap.get(attributeFieldCount.getAttrFieldId());
                count = attributeFieldCount.getObjectCount();
                if (count == 0 && attributeField.isDisabled()) continue;
                countKey = new Link(this.requestContext).setTitle(attributeField.getName());
                countValue = new Link(this.requestContext).setTitle(String.valueOf(count));
                if (count != 0) {
                    path = AppPaths.ISSUES_LIST + "?cmd=search&status=" + attributeField.getId();
                    countKey.setAjaxPath(path);
                    countValue.setAjaxPath(path);
                }
                map = new HashMap<String, String>();
                map.put("countKey", countKey.getString());
                map.put("countValue", countValue.getString());
                statusCounts.add(map);
            }
            for (AttributeFieldCount attributeFieldCount : issueService.getGoupByPriorityCount(countsQuery)) {
                AttributeField attributeField = attrFieldPriorityMap.get(attributeFieldCount.getAttrFieldId());
                count = attributeFieldCount.getObjectCount();
                if (count == 0 && attributeField.isDisabled()) continue;
                countKey = new Link(this.requestContext).setTitle(attributeField.getName());
                countValue = new Link(this.requestContext).setTitle(String.valueOf(count));
                if (count != 0) {
                    path = AppPaths.ISSUES_LIST + "?cmd=search&statusNotEquals=closed&priority=" + attributeFieldCount.getAttrFieldId();
                    countKey.setAjaxPath(path);
                    countValue.setAjaxPath(path);
                }
                map = new HashMap();
                map.put("countKey", countKey.getString());
                map.put("countValue", countValue.getString());
                priorityCounts.add(map);
            }
            for (AttributeFieldCount attributeFieldCount : issueService.getGoupByTypeCount(countsQuery)) {
                AttributeField attributeField = attrFieldTypeMap.get(attributeFieldCount.getAttrFieldId());
                count = attributeFieldCount.getObjectCount();
                if (count == 0 && attributeField.isDisabled()) continue;
                countKey = new Link(this.requestContext).setTitle(attributeField.getName());
                countValue = new Link(this.requestContext).setTitle(String.valueOf(count));
                if (count != 0) {
                    path = AppPaths.ISSUES_LIST + "?cmd=search&statusNotEquals=closed&type=" + attributeFieldCount.getAttrFieldId();
                    countKey.setAjaxPath(path);
                    countValue.setAjaxPath(path);
                }
                map = new HashMap();
                map.put("countKey", countKey.getString());
                map.put("countValue", countValue.getString());
                typeCounts.add(map);
            }
            QueryCriteria assigneeCountQuery = new QueryCriteria();
            assigneeCountQuery.addSortColumn(IssueQueries.getOrderByColumn("assignee_name"));
            for (Map<String, String> map2 : issueService.getGoupByAssigneeCount(assigneeCountQuery)) {
                count = NumberUtils.replaceNull(map2.get("issue_count"));
                AccessUser assigneeUser = new AccessUser();
                assigneeUser.setId(NumberUtils.replaceNull(map2.get("assignee_id")));
                assigneeUser.setUsername(StringUtils.replaceNull(map2.get("assignee_username")));
                assigneeUser.setDisplayName(StringUtils.replaceNull(map2.get("assignee_display_name")));
                String path2 = assigneeUser.getId() == 0 ? AppPaths.ISSUES_LIST + "?cmd=showOpenUnassigned" : AppPaths.ISSUES_LIST + "?cmd=search&statusNotEquals=closed&assignedTo=" + assigneeUser.getId();
                Link countKey2 = new Link(this.requestContext).setTitle(IssueUtils.formatAssigneeName(this.requestContext, assigneeUser)).setAjaxPath(path2);
                Link countValue2 = new Link(this.requestContext).setTitle(String.valueOf(count)).setAjaxPath(path2);
                HashMap<String, String> map22 = new HashMap<String, String>();
                map22.put("countKey", countKey2.getString());
                map22.put("countValue", countValue2.getString());
                assigneeCounts.add(map22);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("hasIssueReadPermission", canViewAllIssues);
        standardTemplate.setAttribute("numIssuesHasPerm", numIssuesHasPerm);
        standardTemplate.setAttribute("links", links);
        standardTemplate.setAttribute("statusCountList", statusCounts);
        standardTemplate.setAttribute("priorityCountList", priorityCounts);
        standardTemplate.setAttribute("typeCountList", typeCounts);
        standardTemplate.setAttribute("assigneeCountList", assigneeCounts);
        standardTemplate.setAttribute("numIssueRecords", numIssueRecords);
        int numDays = 14;
        Map<String, String> recentlyCreatedIssues = issueService.getGroupByRecentCreatedIssues(this.requestContext, new QueryCriteria(), numDays);
        ArrayList<String> createdIssueDates = new ArrayList<String>();
        ArrayList<String> createdIssueCounts = new ArrayList<String>();
        for (Map.Entry<String, String> entry : recentlyCreatedIssues.entrySet()) {
            createdIssueDates.add("'" + entry.getKey() + "'");
            createdIssueCounts.add(entry.getValue());
        }
        standardTemplate.setAttribute("chartLabels", StringUtils.join(createdIssueDates, ","));
        standardTemplate.setAttribute("chartData", StringUtils.join(createdIssueCounts, ","));
        standardTemplate.setAttribute("numDays", numDays);
        IssueSearchTemplate issueSearchTemplate = standardTemplate.addTemplate(new IssueSearchTemplate());
        issueSearchTemplate.setFormAction(AppPaths.ISSUES_LIST);
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("core.moduleName.4");
        headerTemplate.setTitleClassNoLine();
        if (accessUser.hasPermission(AppPaths.ISSUES_ADD)) {
            headerTemplate.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_ADD).setTitleKey("issueMgmt.cmd.issueAdd"));
        }
        if (FeatureManager.isIssueGuestSubmitModuleEnabled(accessUser)) {
            headerTemplate.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ISSUE_PLUGIN_ADD).setTitleKey("issuePlugin.issueAdd.title"));
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

