/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.issues.IssueForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.core.UserSearch;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IssueAddAction
extends Action2 {
    private static final Logger LOGGER = Logger.getLogger(IssueAddAction.class.getName());

    public String add() throws Exception {
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        AccessUser accessUser = this.requestContext.getUser();
        String linkedObjectTypeId = this.requestContext.getParameterString("linkedObjectTypeId");
        this.request.setAttribute("linkedObjectTypeId", (Object)linkedObjectTypeId);
        String linkedObjectId = this.requestContext.getParameterString("linkedObjectId");
        this.request.setAttribute("linkedObjectId", (Object)linkedObjectId);
        IssueForm actionForm = this.getBaseForm(IssueForm.class);
        actionForm.setId("issueAddForm");
        Issue issue = new Issue();
        issue.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            IssueUtils.setDefaultDueDate(this.requestContext, issue);
            actionForm.setIssue(issue);
            actionForm.setCreator(0);
        }
        if (accessUser.hasPermission(31)) {
            if (actionForm.getCreator() != 0) {
                this.request.setAttribute("hideIssueCreatedBy", (Object)"display:none");
            } else {
                this.request.setAttribute("hideIssueCreatedBySelect", (Object)"display:none");
            }
            this.request.setAttribute("changeSubmitterLink", (Object)new Link(this.requestContext).setTitleKey("issues.changeSubmitter").setJavascript("Js.Display.hide('issueCreatedBy');Js.Display.show('issueCreatedBySelect');").getString());
            this.request.setAttribute("changeSubmitterSelfLink", (Object)new Link(this.requestContext).setTitleKey("issues.changeSubmitter.self").setJavascript("Js.Display.hide('issueCreatedBySelect');Js.Display.show('issueCreatedBy');").getString());
        }
        this.request.setAttribute("createdBy", (Object)AdminUtils.getSystemUsername(this.requestContext, accessUser));
        UserSearch userSearch = new UserSearch();
        userSearch.put("userStatus", AttributeFieldIds.USER_STATUS_ENABLED);
        QueryCriteria query = new QueryCriteria(userSearch);
        query.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        List<AccessUser> users = adminService.getUsers(query);
        ArrayList<LabelValueBean> assigneeOptions = new ArrayList<LabelValueBean>();
        assigneeOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.colName.unassigned"), "0"));
        for (AccessUser accessUser2 : users) {
            assigneeOptions.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, accessUser2), String.valueOf(accessUser2.getId())));
        }
        ArrayList<LabelValueBean> subscribersOptions = new ArrayList<LabelValueBean>();
        for (AccessUser accessUser3 : users) {
            subscribersOptions.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, accessUser3), String.valueOf(accessUser3.getId())));
        }
        ArrayList<LabelValueBean> arrayList = new ArrayList<LabelValueBean>();
        arrayList.add(new SelectOneLabelValueBean(this.requestContext, "0"));
        for (AccessUser user : users) {
            arrayList.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, user), String.valueOf(user.getId())));
        }
        this.request.setAttribute("creatorOptions", arrayList);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("issue", (Object)issue);
        standardTemplate.setPathAttribute("formAction", AppPaths.ISSUES_ADD_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.ISSUES_ADD);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ISSUES_LIST).getString());
        this.request.setAttribute("emailNotification", (Object)ConfigManager.email.isIssueNotificationFromUiEnabled());
        this.request.setAttribute("statusOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.ISSUE_STATUS));
        this.request.setAttribute("priorityOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.ISSUE_PRIORITY));
        this.request.setAttribute("typeOptions", attributeManager.getActiveAttrFieldOptionsCache(Attributes.ISSUE_TYPE));
        this.request.setAttribute("resolutionOptions", new AttributeManager(this.requestContext).setOptional(true).getActiveAttrFieldOptionsCache(Attributes.ISSUE_RESOLUTION));
        this.request.setAttribute("assignedToOptions", assigneeOptions);
        this.request.setAttribute("availableSubscribersOptions", subscribersOptions);
        this.request.setAttribute("selectedSubscribersOptions", new ArrayList());
        this.request.setAttribute("formDisableIssueDueDate", (Object)(actionForm.getHasDueDate() != 1 ? 1 : 0));
        this.request.setAttribute("dueDateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("dueMonthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("dueYearOptions", CalendarUtils.getYearOptions(this.requestContext));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("issueMgmt.cmd.issueAdd");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.ISSUE);
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getType());
        customFieldsTemplate.setForm(actionForm);
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("issueMgmt.issueAdd.sectionHeader");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        IssueForm actionForm = this.saveActionForm(new IssueForm());
        Issue issue = new Issue();
        issue.setSubject(actionForm.getIssueName());
        issue.setDescription(actionForm.getDescription());
        issue.setStatus(actionForm.getStatus());
        issue.setType(actionForm.getType());
        issue.setPriority(actionForm.getPriority());
        issue.setResolution(actionForm.getResolution());
        issue.getAssignee().setId(actionForm.getIssueAssignee());
        issue.getSelectedSubscribers().addAll(actionForm.getSelectedSubscribers());
        if (accessUser.hasPermission(31)) {
            issue.setProxyUserId(actionForm.getCreator());
        }
        issue.setCreatorIP(this.request.getRemoteAddr());
        issue.setHasDueDate(actionForm.getHasDueDate() == 1);
        if (actionForm.getHasDueDate() == 1) {
            issue.setDueDate(actionForm.getDueDateYear(), actionForm.getDueDateMonth(), actionForm.getDueDateDate());
        }
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        Map<Integer, Attribute> customAttributes = attributeManager.populateCustomFieldValues(actionForm, issue);
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        ActionMessages errors = issueService.addIssue(issue, customAttributes);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ISSUES_ADD + "?" + "_error=true");
        }
        if (ConfigManager.email.isIssueNotificationFromUiEnabled() && actionForm.getSuppressNotification() != 1) {
            try {
                Issue updatedIssue = issueService.getPublicIssue(issue.getId());
                String emailBody = ConfigManager.email.getIssueAddEmailTemplate().isEmpty() ? Localizer.getText(this.requestContext, "issues.issueAdd2.emailBody") : ConfigManager.email.getIssueAddEmailTemplate();
                emailBody = emailBody.replace("%ISSUE_ASSIGNEE%", AdminUtils.getSystemUsername(this.requestContext, updatedIssue.getAssignee())).replace("%ISSUE_ID%", String.valueOf(updatedIssue.getId())).replace("%ISSUE_REPORTED_BY%", AdminUtils.getSystemUsername(this.requestContext, updatedIssue.getCreator())).replace("%ISSUE_REPORTED_DATE%", updatedIssue.getCreationDate()).replace("%ISSUE_STATUS%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_STATUS, updatedIssue.getStatus())).replace("%ISSUE_PRIORITY%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_PRIORITY, updatedIssue.getPriority())).replace("%ISSUE_TYPE%", attributeManager.getAttrFieldNameCache(Attributes.ISSUE_TYPE, updatedIssue.getType())).replace("%ISSUE_DESCRIPTION%", updatedIssue.getDescription()).replace("%ISSUE_URL%", ConfigManager.system.getAppUrl() + AppPaths.ROOT + AppPaths.ISSUES_DETAIL + "?issueId=" + updatedIssue.getId());
                issueService.sendMail(updatedIssue, null, emailBody);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Problem sending issue notification", e);
            }
        }
        Integer objectTypeId = NumberUtils.replaceNull(actionForm.getLinkedObjectTypeId());
        Integer objectId = NumberUtils.replaceNull(actionForm.getLinkedObjectId());
        if (objectTypeId != 0 && objectId != 0) {
            if (objectTypeId.equals(ObjectTypes.HARDWARE)) {
                return this.ajaxUpdateView(AppPaths.HARDWARE_ISSUE_ADD_2 + "?issueId=" + issue.getId() + "&hardwareId=" + actionForm.getLinkedObjectId());
            }
            if (objectTypeId.equals(ObjectTypes.SOFTWARE)) {
                return this.ajaxUpdateView(AppPaths.SOFTWARE_ISSUE_ADD_2 + "?issueId=" + issue.getId() + "&softwareId=" + actionForm.getLinkedObjectId());
            }
            if (objectTypeId.equals(ObjectTypes.COMPANY)) {
                return this.ajaxUpdateView(AppPaths.CONTACTS_COMPANY_ISSUE_ADD_2 + "?issueId=" + issue.getId() + "&companyId=" + actionForm.getLinkedObjectId());
            }
            return null;
        }
        return this.ajaxUpdateView(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
    }
}

