/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.IssueAccess;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IssueAssociateTemplate
extends BaseTemplate {
    private String issueId;
    private Integer linkedObjectTypeId;
    private Integer linkedObjectId;
    private String formSearchAction;
    private String formSaveAction;
    private String formCancelAction;

    public IssueAssociateTemplate() {
        super(IssueAssociateTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(new ActionErrorsTemplate());
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        AccessUser user = this.requestContext.getUser();
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        ArrayList issueList = new ArrayList();
        if (this.issueId.isEmpty()) {
            this.request.setAttribute("selectIssueMessage", (Object)"form.noSearchInput");
        } else if (issueList.isEmpty()) {
            this.request.setAttribute("selectIssueMessage", (Object)"form.noSearchResult");
        }
        if (Access.hasPermission(user, AppPaths.ISSUES_ADD)) {
            this.request.setAttribute("issueAddLink", (Object)new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_ADD + "?linkedObjectTypeId=" + this.linkedObjectTypeId + "&linkedObjectId=" + this.linkedObjectId).setTitleKey("system.createLinkIssues").getString());
        }
        if (!this.issueId.isEmpty()) {
            IssueSearch issueSearch = new IssueSearch();
            issueSearch.put("issueIdEquals", this.issueId);
            List<Issue> issues = issueService.getIssues(new QueryCriteria(issueSearch));
            if (!issues.isEmpty()) {
                boolean hasIssueDetailAccess = Access.hasPermission(user, AppPaths.ISSUES_DETAIL);
                IssueAccess access = new IssueAccess(user);
                if (hasIssueDetailAccess && !access.hasReadAllPermission()) {
                    issueSearch.put("issuePermittedUserId", user.getId());
                    access.setAllowedIssues(issueService.getIssueIds(new QueryCriteria(issueSearch)));
                }
                for (Issue issue : issues) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("issueId", issue.getId());
                    Link link = new Link(this.requestContext);
                    link.setTitle(issue.getSubject());
                    if (hasIssueDetailAccess && access.hasPermission(issue.getId())) {
                        link.setAjaxPath(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
                    }
                    map.put("issueTitle", link.getString());
                    issueList.add(map);
                }
                this.request.setAttribute("issueList", issueList);
            }
        }
        if (issueList.isEmpty()) {
            this.request.setAttribute("disableSaveButton", (Object)"disabled");
        }
        this.request.setAttribute("formSearchAction", (Object)(AppPaths.ROOT + this.formSearchAction));
        this.request.setAttribute("formSaveAction", (Object)(AppPaths.ROOT + this.formSaveAction));
        this.request.setAttribute("formCancelLink", (Object)Links.getCancelLink(this.requestContext, this.formCancelAction).getString());
    }

    @Override
    public String getJspPath() {
        return "/jsp/issues/IssueAssociateTemplate.jsp";
    }

    public void setFormSaveAction(String formSaveAction) {
        this.formSaveAction = formSaveAction;
    }

    public Integer getLinkedObjectTypeId() {
        return this.linkedObjectTypeId;
    }

    public void setLinkedObjectTypeId(Integer linkedObjectTypeId) {
        this.linkedObjectTypeId = linkedObjectTypeId;
    }

    public Integer getLinkedObjectId() {
        return this.linkedObjectId;
    }

    public void setLinkedObjectId(Integer linkedObjectId) {
        this.linkedObjectId = linkedObjectId;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public void setIssueId(String issueId) {
        this.issueId = issueId;
    }

    public String getFormSearchAction() {
        return this.formSearchAction;
    }

    public void setFormSearchAction(String formSearchAction) {
        this.formSearchAction = formSearchAction;
    }

    public String getFormCancelAction() {
        return this.formCancelAction;
    }

    public void setFormCancelAction(String formCancelAction) {
        this.formCancelAction = formCancelAction;
    }

    public String getFormSaveAction() {
        return this.formSaveAction;
    }
}

