/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.ObjectDeleteTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.issues.IssueSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.util.List;

public class IssueDeleteAction
extends Action2 {
    public String delete() throws Exception {
        Integer issueId = this.requestContext.getParameter("issueId");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        Issue issue = issueService.getIssue(issueId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("issues.issueDelete.title");
        IssueSpecTemplate spec = standardTemplate.addTemplate(new IssueSpecTemplate(issue));
        spec.setHeaderText(issue.getSubject());
        ObjectDeleteTemplate delete = standardTemplate.addTemplate(new ObjectDeleteTemplate());
        delete.setFormAjaxAction(AppPaths.ISSUES_DELETE_2 + "?issueId=" + issueId);
        delete.setFormCancelAction(AppPaths.ISSUES_DETAIL + "?issueId=" + issueId);
        delete.setConfirmationMsgKey("issues.issueDelete.confirm");
        delete.setSubmitButtonKey("issues.issueDelete.submitButton");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer issueId = this.requestContext.getParameter("issueId");
        List<Integer> issueIds = this.requestContext.getParameters("issueIds");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        if (!issueIds.isEmpty()) {
            for (Integer deleteIssueId : issueIds) {
                issueService.getIssue(deleteIssueId);
                ActionMessages errors = issueService.deleteIssue(deleteIssueId);
                if (errors.isEmpty()) continue;
                this.saveActionErrors(errors);
                break;
            }
        } else {
            issueService.getIssue(issueId);
            ActionMessages errors = issueService.deleteIssue(issueId);
            if (!errors.isEmpty()) {
                this.saveActionErrors(errors);
                return this.ajaxUpdateView(AppPaths.ISSUES_DELETE + "?issueId=" + issueId + "&" + "_error=true");
            }
        }
        return this.ajaxUpdateView(AppPaths.ISSUES_LIST);
    }
}

