/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.issues.IssueSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SortByIconLink;
import com.kwoksys.framework.util.DatetimeUtils;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.NumberUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueDetailAction
extends Action2 {
    public static final String ISSUE_HTML_EMAIL_PARAM = "issueHtmlEmail";

    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer issueId = this.requestContext.getParameter("issueId");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        Issue issue = issueService.getIssue(issueId);
        String cmd = this.requestContext.getParameterString("cmd");
        if (ISSUE_HTML_EMAIL_PARAM.equals(cmd)) {
            this.request.setAttribute("issueEmail", (Object)issue.getDescription());
            return "htmlEmailWidget";
        }
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "ISSUE_HISTORY_ORDER_BY", "creation_date");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "ISSUE_HISTORY_ORDER", "desc");
        QueryCriteria query = new QueryCriteria();
        if (Issue.isSortableHistoryColumn(orderBy)) {
            query.addSortColumn(IssueQueries.getOrderByColumn(orderBy), order);
        }
        SortByIconLink sortByUi = new SortByIconLink(order);
        String urlSortBy = sortByUi.getUrl();
        List<Map<String, String>> changeList = issueService.getHistory(query, issueId);
        ArrayList issueHistoryList = new ArrayList();
        String userDetailPath = AppPaths.ADMIN_USER_DETAIL;
        boolean hasUserDetailAccess = Access.hasPermission(user, userDetailPath);
        boolean canDownloadFile = Access.hasPermission(user, AppPaths.ISSUES_FILE_DOWNLOAD);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        Link dateHeaderLink = new Link(this.requestContext);
        dateHeaderLink.setTitleKey("issueMgmt.issueDetail.historyDateHeader");
        if (!changeList.isEmpty()) {
            if (Issue.isSortableHistoryColumn(orderBy)) {
                dateHeaderLink.setAjaxPath(AppPaths.ISSUES_DETAIL + "?issueId=" + issueId + "&orderBy=" + "creation_date" + urlSortBy);
                dateHeaderLink.setInlineImage(sortByUi.getImg(orderBy));
            }
            String creationDate = "";
            Counter counter = new Counter();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rownum", counter.incr() + ".");
            for (Map<String, String> change : changeList) {
                if (creationDate.isEmpty()) {
                    creationDate = change.get("creation_date");
                }
                if (!creationDate.equals(change.get("creation_date"))) {
                    creationDate = change.get("creation_date");
                    issueHistoryList.add(map);
                    map = new HashMap();
                    map.put("rownum", counter.incr() + ".");
                }
                String changeField = String.valueOf(change.get("issue_change_field"));
                AccessUser creatorUser = new AccessUser();
                creatorUser.setId(NumberUtils.replaceNull(change.get("creator")));
                creatorUser.setUsername(change.get("creator_username"));
                creatorUser.setDisplayName(change.get("creator_display_name"));
                map.put("changeCreator", Links.getUserIconLink(this.requestContext, creatorUser, hasUserDetailAccess, false).getString());
                map.put("changeCreatorEmail", change.get("issue_created_from_email"));
                String thisCreationDate = "";
                try {
                    thisCreationDate = DatetimeUtils.toLocalDatetime(DatetimeUtils.parseDate(String.valueOf(change.get("creation_date")), ConfigManager.system.getDatetimeBase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                map.put("changeCreationDate", thisCreationDate);
                if (changeField.equals("comment")) {
                    String comment = change.get("issue_comment_description") == null ? "" : change.get("issue_comment_description").toString();
                    map.put("changeComment", HtmlUtils.formatMultiLineDisplay(comment));
                }
                if (changeField.equals("subject")) {
                    Object[] subjectArgs = new Object[]{HtmlUtils.encode(change.get("issue_change_varchar_old")), HtmlUtils.encode(change.get("issue_change_varchar_new"))};
                    map.put("changeSubject", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historySubject", subjectArgs));
                }
                if (changeField.equals("type")) {
                    Object[] typeArgs = new Object[]{HtmlUtils.encode(change.get("issue_change_int_old")), HtmlUtils.encode(change.get("issue_change_int_new"))};
                    map.put("changeType", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyType", typeArgs));
                }
                if (changeField.equals("status")) {
                    Object[] staArgs = new Object[]{HtmlUtils.encode(change.get("issue_change_int_old")), HtmlUtils.encode(change.get("issue_change_int_new"))};
                    map.put("changeStatus", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyStatus", staArgs));
                }
                if (changeField.equals("priority")) {
                    Object[] priArgs = new Object[]{HtmlUtils.encode(change.get("issue_change_int_old")), HtmlUtils.encode(change.get("issue_change_int_new"))};
                    map.put("changePriority", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyPriority", priArgs));
                }
                if (changeField.equals("resolution")) {
                    Object[] resArgs = new Object[]{HtmlUtils.encode(change.get("issue_change_int_old")), HtmlUtils.encode(change.get("issue_change_int_new"))};
                    map.put("changeResolution", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyResolution", resArgs));
                }
                if (changeField.equals("assignee")) {
                    AccessUser removedAssignee = new AccessUser();
                    removedAssignee.setId(NumberUtils.replaceNull(change.get("issue_change_int_old")));
                    removedAssignee.setDisplayName(StringUtils.replaceNull(change.get("issue_change_varchar_old")));
                    removedAssignee.setUsername(removedAssignee.getDisplayName());
                    String removedAssigneeName = IssueUtils.getAssigneeIconLink(this.requestContext, hasUserDetailAccess, removedAssignee);
                    AccessUser addedAssignee = new AccessUser();
                    addedAssignee.setId(NumberUtils.replaceNull(change.get("issue_change_int_new")));
                    addedAssignee.setDisplayName(StringUtils.replaceNull(change.get("issue_change_varchar_new")));
                    addedAssignee.setUsername(addedAssignee.getDisplayName());
                    String addedAssigneeName = IssueUtils.getAssigneeIconLink(this.requestContext, hasUserDetailAccess, addedAssignee);
                    Object[] assignArgs = new Object[]{removedAssigneeName, addedAssigneeName};
                    map.put("changeAssignee", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyAssignee", assignArgs));
                }
                if (!changeField.equals("file")) continue;
                String path = AppPaths.ISSUES_FILE_DOWNLOAD + "?issueId=" + issueId + "&fileId=" + change.get("file_id");
                String fileIconLink = Links.getFileIconLink(this.requestContext, canDownloadFile, change.get("file_name").toString(), path).getString();
                Object[] params = new String[]{StringUtils.replaceNull(change.get("file_friendly_name")), fileIconLink, FileUtils.formatFileSize(this.requestContext, NumberUtils.replaceNull(change.get("file_byte_size")).intValue())};
                map.put("changeFile", Localizer.getText(this.requestContext, "issueMgmt.issueDetail.historyDownloadFile", params));
            }
            if (!map.isEmpty()) {
                issueHistoryList.add(map);
            }
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(4);
            empty.setRowText(Localizer.getText(this.requestContext, "issueMgmt.issueDetail.emptyTableMessage"));
        }
        this.request.setAttribute("issueHistoryList", issueHistoryList);
        this.request.setAttribute("issueChangeCreationDateHeader", (Object)dateHeaderLink.getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("issueMgmt.issueDetail.title", new Object[]{issue.getSubject()});
        if (Access.hasPermission(user, AppPaths.ISSUES_EDIT)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_EDIT + "?issueId=" + issueId).setTitleKey("issueMgmt.cmd.issueEdit"));
        }
        if (Access.hasPermission(user, AppPaths.ISSUES_FILE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setTitleKey("issueMgmt.cmd.issueFileAdd");
            if (fileService.isDirectoryExist(ConfigManager.file.getIssueFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.ISSUES_FILE_ADD + "?issueId=" + issueId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.ISSUES_DELETE)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_DELETE + "?issueId=" + issueId).setTitleKey("issueMgmt.cmd.issueDelete"));
        }
        if (Access.hasPermission(user, AppPaths.ISSUES_LIST)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_LIST).setTitleKey("issueMgmt.cmd.issueList"));
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(IssueUtils.getIssueTabs(this.requestContext, issue, null));
        tabs.setTabActive("history");
        IssueSpecTemplate spec = standardTemplate.addTemplate(new IssueSpecTemplate(issue));
        spec.setHeaderText(issue.getSubject());
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.ISSUE);
        customFieldsTemplate.setObjectId(issueId);
        customFieldsTemplate.setObjectAttrTypeId(issue.getType());
        customFieldsTemplate.setShowDefaultHeader(false);
        return standardTemplate.findTemplate("standard_template");
    }
}

