/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.issues.IssueForm;
import com.kwoksys.action.issues.IssueSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.Map;

public class IssueEditAction
extends Action2 {
    public String edit() throws Exception {
        IssueForm actionForm = this.getBaseForm(IssueForm.class);
        actionForm.setId("issueEditForm");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        Issue issue = issueService.getIssue(actionForm.getIssueId());
        issue.loadAttrs(this.requestContext);
        if (!actionForm.isResubmit()) {
            actionForm.setIssue(issue);
        }
        ArrayList<LabelValueBean> assigneeOptions = new ArrayList<LabelValueBean>();
        assigneeOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.colName.unassigned"), "0"));
        assigneeOptions.addAll(AdminUtils.getUserOptions(this.requestContext, issue.getAssignee().getId()));
        ArrayList<LabelValueBean> availableSubscribers = new ArrayList<LabelValueBean>();
        for (AccessUser accessUser : issueService.getAvailableSubscribers(issue.getId())) {
            availableSubscribers.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, accessUser), String.valueOf(accessUser.getId())));
        }
        ArrayList<LabelValueBean> selectedSubscribers = new ArrayList<LabelValueBean>();
        for (AccessUser selectedSubscriber : issueService.getSelectedSubscribers(issue.getId())) {
            selectedSubscribers.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, selectedSubscriber), String.valueOf(selectedSubscriber.getId())));
        }
        int n = NumberUtils.replaceNull(actionForm.getDueDateYear(), 0);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        this.request.setAttribute("issue", (Object)issue);
        standardTemplate.setPathAttribute("formAction", AppPaths.ISSUES_EDIT_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.ISSUES_EDIT);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId()).getString());
        this.request.setAttribute("emailNotification", (Object)ConfigManager.email.isIssueNotificationFromUiEnabled());
        standardTemplate.setAttribute("statusOptions", new AttributeManager(this.requestContext).setSelectedAttrFieldId(issue.getStatus()).getActiveAttrFieldOptionsCache(Attributes.ISSUE_STATUS));
        standardTemplate.setAttribute("priorityOptions", new AttributeManager(this.requestContext).setSelectedAttrFieldId(issue.getPriority()).getActiveAttrFieldOptionsCache(Attributes.ISSUE_PRIORITY));
        standardTemplate.setAttribute("typeOptions", new AttributeManager(this.requestContext).setSelectedAttrFieldId(issue.getType()).getActiveAttrFieldOptionsCache(Attributes.ISSUE_TYPE));
        standardTemplate.setAttribute("resolutionOptions", new AttributeManager(this.requestContext).setOptional(true).setSelectedAttrFieldId(issue.getResolution()).getActiveAttrFieldOptionsCache(Attributes.ISSUE_RESOLUTION));
        this.request.setAttribute("assignedToOptions", assigneeOptions);
        this.request.setAttribute("availableSubscribersOptions", availableSubscribers);
        this.request.setAttribute("selectedSubscribersOptions", selectedSubscribers);
        this.request.setAttribute("formDisableIssueDueDate", (Object)(actionForm.getHasDueDate() != 1 ? 1 : 0));
        this.request.setAttribute("dueDateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("dueMonthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("dueYearOptions", CalendarUtils.getExtraYearOptions(this.requestContext, n));
        IssueSpecTemplate spec = standardTemplate.addTemplate(new IssueSpecTemplate(issue));
        spec.setHeaderText(Localizer.getText(this.requestContext, "issueMgmt.issueEdit.header"));
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("issueMgmt.issueEdit.issueUpdateSectionTitle");
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.ISSUE);
        customFieldsTemplate.setObjectId(issue.getId());
        customFieldsTemplate.setObjectAttrTypeId(actionForm.getType());
        customFieldsTemplate.setForm(actionForm);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        AttributeManager attributeManager;
        Map<Integer, Attribute> customAttributes;
        ActionMessages errors;
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        IssueForm actionForm = this.saveActionForm(new IssueForm());
        Issue issue = issueService.getIssue(actionForm.getIssueId());
        Integer prevAssigneeId = issue.getAssignee().getId();
        issue.setSubject(actionForm.getIssueName());
        issue.setFollowup(actionForm.getFollowup());
        issue.setStatus(actionForm.getStatus());
        issue.setType(actionForm.getType());
        issue.setPriority(actionForm.getPriority());
        issue.setResolution(actionForm.getResolution());
        issue.getAssignee().setId(actionForm.getIssueAssignee());
        issue.getSelectedSubscribers().addAll(actionForm.getSelectedSubscribers());
        issue.setFromEmail("");
        issue.setHasDueDate(actionForm.getHasDueDate() == 1);
        if (actionForm.getHasDueDate() == 1) {
            issue.setDueDate(actionForm.getDueDateYear(), actionForm.getDueDateMonth(), actionForm.getDueDateDate());
        }
        if (!(errors = issueService.updateIssue(issue, customAttributes = (attributeManager = new AttributeManager(this.requestContext)).populateCustomFieldValues(actionForm, issue))).isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.ISSUES_EDIT + "?issueId=" + issue.getId() + "&" + "_error=true");
        }
        if (ConfigManager.email.isIssueNotificationFromUiEnabled() && actionForm.getSuppressNotification() != 1) {
            issueService.sendUpdateIssueNotification(issue, prevAssigneeId);
        }
        return this.ajaxUpdateView(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
    }
}

