/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.action.issues.IssueSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.io.FileNotFoundException;

public class IssueFileAction
extends Action2 {
    public String add() throws Exception {
        Integer issueId = this.requestContext.getParameter("issueId");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        Issue issue = issueService.getIssue(issueId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        IssueSpecTemplate spec = standardTemplate.addTemplate(new IssueSpecTemplate(issue));
        spec.setHeaderText(issue.getSubject());
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(this.getBaseForm(FileUploadForm.class)));
        fileAdd.setFileName(this.requestContext.getParameterString("fileName0"));
        fileAdd.setFormAction(AppPaths.ISSUES_FILE_ADD_2 + "?issueId=" + issueId);
        fileAdd.setFormCancelAction(AppPaths.ISSUES_DETAIL + "?issueId=" + issueId);
        fileAdd.getErrorsTemplate().setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        FileUploadForm actionForm = this.saveActionForm(new FileUploadForm());
        Issue issue = new Issue();
        issue.setId(this.requestContext.getParameter("issueId"));
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        ActionMessages errors = issueService.addIssueFile(issue, actionForm);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.ISSUES_FILE_ADD + "?" + "_error=true" + "&issueId=" + issue.getId());
        }
        return this.redirect(AppPaths.ISSUES_DETAIL + "?issueId=" + issue.getId());
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        try {
            Integer issueId = this.requestContext.getParameter("issueId");
            IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
            issueService.getIssue(issueId);
            Integer fileId = this.requestContext.getParameter("fileId");
            File file = issueService.getIssueFile(issueId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }
}

