/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.biz.base.BaseObjectForm;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.util.DatetimeUtils;
import java.util.List;

public class IssueForm
extends BaseObjectForm {
    private Integer issueId;
    private String issueName;
    private String description;
    private String followup;
    private Integer status;
    private Integer type;
    private Integer priority;
    private Integer resolution;
    private Integer issueAssignee;
    private List<Integer> availableSubscribers;
    private List<Integer> selectedSubscribers;
    private int suppressNotification;
    private int hasDueDate;
    private String dueDateDate;
    private String dueDateMonth;
    private String dueDateYear;
    private String linkedObjectTypeId;
    private String linkedObjectId;
    private Integer creator;
    private Integer proxyCreator;

    @Override
    public void setRequest(RequestContext requestContext) {
        this.issueId = requestContext.getParameterInteger("issueId");
        this.issueName = requestContext.getParameterString("issueName");
        this.description = requestContext.getParameterString("description");
        this.followup = requestContext.getParameterString("followup");
        this.status = requestContext.getParameterInteger("status");
        this.type = requestContext.getParameterInteger("type");
        this.priority = requestContext.getParameterInteger("priority");
        this.resolution = requestContext.getParameterInteger("resolution");
        this.issueAssignee = requestContext.getParameterInteger("issueAssignee");
        this.availableSubscribers = requestContext.getParameters("availableSubscribers");
        this.selectedSubscribers = requestContext.getParameters("selectedSubscribers");
        this.suppressNotification = requestContext.getParameter("suppressNotification");
        this.hasDueDate = requestContext.getParameter("hasDueDate");
        this.dueDateDate = requestContext.getParameterString("dueDateDate");
        this.dueDateMonth = requestContext.getParameterString("dueDateMonth");
        this.dueDateYear = requestContext.getParameterString("dueDateYear");
        this.linkedObjectTypeId = requestContext.getParameterString("linkedObjectTypeId");
        this.linkedObjectId = requestContext.getParameterString("linkedObjectId");
        this.creator = requestContext.getParameterInteger("creator");
        this.proxyCreator = requestContext.getParameterInteger("proxyCreator");
    }

    public void setIssue(Issue issue) {
        this.issueName = issue.getSubject();
        this.description = issue.getDescription();
        this.followup = issue.getFollowup();
        this.status = issue.getStatus();
        this.type = issue.getType();
        this.priority = issue.getPriority();
        this.resolution = issue.getResolution();
        this.suppressNotification = 0;
        this.issueAssignee = issue.getAssignee().getId() != null ? issue.getAssignee().getId() : 0;
        this.hasDueDate = issue.isHasDueDate() ? 1 : 0;
        this.dueDateYear = DatetimeUtils.toYearString(issue.getDueDate());
        this.dueDateMonth = DatetimeUtils.toMonthString(issue.getDueDate());
        this.dueDateDate = DatetimeUtils.toDateString(issue.getDueDate());
    }

    public Integer getIssueId() {
        return this.issueId;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public void setIssueName(String issueName) {
        this.issueName = issueName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFollowup() {
        return this.followup;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getResolution() {
        return this.resolution;
    }

    public Integer getIssueAssignee() {
        return this.issueAssignee;
    }

    public List<Integer> getAvailableSubscribers() {
        return this.availableSubscribers;
    }

    public List<Integer> getSelectedSubscribers() {
        return this.selectedSubscribers;
    }

    public int getSuppressNotification() {
        return this.suppressNotification;
    }

    public int getHasDueDate() {
        return this.hasDueDate;
    }

    public String getDueDateDate() {
        return this.dueDateDate;
    }

    public String getDueDateMonth() {
        return this.dueDateMonth;
    }

    public String getDueDateYear() {
        return this.dueDateYear;
    }

    public String getLinkedObjectTypeId() {
        return this.linkedObjectTypeId;
    }

    public void setLinkedObjectTypeId(String linkedObjectTypeId) {
        this.linkedObjectTypeId = linkedObjectTypeId;
    }

    public String getLinkedObjectId() {
        return this.linkedObjectId;
    }

    public void setLinkedObjectId(String linkedObjectId) {
        this.linkedObjectId = linkedObjectId;
    }

    public Integer getProxyCreator() {
        return this.proxyCreator;
    }

    public Integer getCreator() {
        return this.creator;
    }

    public void setCreator(Integer creator) {
        this.creator = creator;
    }
}

