/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.issues.IssueSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.IssueAccess;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.FeatureManager;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.Arrays;
import java.util.List;

public class IssueListAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        IssueSearchForm actionForm = this.getSessionBaseForm(IssueSearchForm.class);
        AccessUser accessUser = this.requestContext.getUser();
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String cmd = this.requestContext.getParameterString("cmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "ISSUES_ORDER_BY", "creation_date");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "ISSUES_ORDER", "desc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("ISSUES_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "ISSUES_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getIssueRows());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        IssueSearch issueSearch = new IssueSearch(this.requestContext, "ISSUE_SEARCH_CRITERIA_MAP");
        issueSearch.prepareMap(actionForm);
        if (!accessUser.hasPermission(1)) {
            issueSearch.put("issuePermittedUserId", accessUser.getId());
        }
        QueryCriteria query = new QueryCriteria(issueSearch);
        query.setLimit(rowLimit, rowStart);
        if (IssueUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(IssueQueries.getOrderByColumn(orderBy), order);
        }
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        List<String> columnHeaders = IssueUtils.getIssueColumnHeaders();
        int rowCount = issueService.getCount(query);
        List<LabelValueBean> filterOptions = Arrays.asList(new SelectOneLabelValueBean(this.requestContext, "showAll"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.showNonClosed"), "showNonClosed"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.showOpenUnassigned"), "showOpenUnassigned"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.showMyIssues"), "showMyIssues"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.showMyReportedIssues"), "showMyReportedIssues"));
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.ISSUES_LIST);
        standardTemplate.setAttribute("filterOptions", filterOptions);
        if (!issueSearch.getSearchCriteriaMap().isEmpty()) {
            standardTemplate.setAttribute("searchResultText", Localizer.getText(this.requestContext, "issueMgmt.issueList.searchResult"));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "issueMgmt.issueList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.ISSUES_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.ISSUES_LIST + "?rowStart=");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("issueMgmt.issueList.title");
        header.setTitleClassNoLine();
        if (Access.hasPermission(accessUser, AppPaths.ISSUES_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ISSUES_ADD);
            link.setTitleKey("issueMgmt.cmd.issueAdd");
            header.addHeaderCmds(link);
        }
        if (FeatureManager.isIssueGuestSubmitModuleEnabled(accessUser)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ISSUE_PLUGIN_ADD);
            link.setTitleKey("issuePlugin.issueAdd.title");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(accessUser, AppPaths.ISSUES_LIST_EXPORT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.ISSUES_LIST_EXPORT + "?rowCmd=" + rowCmd + "&rowStart=" + rowStart);
            link.setTitleKey("issues.cmd.issueExport");
            link.setInlineImage(Image.getInstance().getFileCsvIcon());
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(IssueUtils.getSortableColumns());
        tableTemplate.setColumnPath(AppPaths.ISSUES_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("issueMgmt.issueList.emptyTableMessage");
        if (rowCount != 0) {
            List<Issue> issues = issueService.getIssues(query);
            boolean hasIssueDetailAccess = Access.hasPermission(accessUser, AppPaths.ISSUES_DETAIL);
            IssueAccess access = new IssueAccess(accessUser);
            if (hasIssueDetailAccess) {
                access.setAllowedIssues(issues);
            }
            List<DataRow> dataList = IssueUtils.formatIssues(this.requestContext, issues, access, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        if (ConfigManager.app.isIssuesMultipleDeleteEnabled() && Access.hasPermission(accessUser, AppPaths.ISSUES_DELETE_2)) {
            tableTemplate.setFormName(IssueSearchForm.class.getSimpleName());
            tableTemplate.setFormRemoveItemAction(AppPaths.ISSUES_DELETE_2);
            tableTemplate.setFormRowIdName("issueIds");
            tableTemplate.setFormSelectMultipleRows(true);
            tableTemplate.getFormButtons().put("common.action.Delete", "common.form.confirmDelete");
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

