/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.IssueAccess;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.ObjectLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IssueListTemplate
extends BaseTemplate {
    private AccessUser accessUser;
    private QueryCriteria queryCriteria;
    private ObjectLink objectMap;
    private Map<String, String> formHiddenVariableMap = new HashMap<String, String>();
    private String formRemoveItemAction;
    private String formRowIdName;
    private List<String> columnHeaders;
    private String emptyTableRowKey;
    private TableTemplate tableTemplate = new TableTemplate();

    public IssueListTemplate() {
        super(IssueListTemplate.class);
    }

    @Override
    public void init() {
        this.addTemplate(this.tableTemplate);
    }

    @Override
    public void applyTemplate() throws Exception {
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        List<Issue> issueList = issueService.getLinkedIssues(this.queryCriteria, this.objectMap);
        boolean hasIssueDetailAccess = this.accessUser.hasPermission(AppPaths.ISSUES_DETAIL);
        IssueAccess access = new IssueAccess(this.accessUser);
        if (hasIssueDetailAccess && !access.hasReadAllPermission()) {
            IssueSearch issueSearch = new IssueSearch();
            issueSearch.put("issuePermittedUserId", this.accessUser.getId());
            List<Issue> allowedIssues = issueService.getLinkedIssues(new QueryCriteria(issueSearch), this.objectMap);
            access.setAllowedIssues(allowedIssues);
        }
        List<DataRow> formattedList = IssueUtils.formatIssues(this.requestContext, issueList, access, new Counter());
        this.tableTemplate.setDataList(formattedList);
        this.tableTemplate.setColumnHeaders(this.columnHeaders);
        this.tableTemplate.setColumnTextKey("common.column.");
        this.tableTemplate.setEmptyRowMsgKey(this.emptyTableRowKey);
        this.tableTemplate.setFormRemoveItemAction(this.formRemoveItemAction);
        this.tableTemplate.setFormHiddenVariableMap(this.formHiddenVariableMap);
        this.tableTemplate.setFormRowIdName(this.formRowIdName);
    }

    @Override
    public String getJspPath() {
        return "/jsp/common/template/Table.jsp";
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    public void setObjectMap(ObjectLink objectMap) {
        this.objectMap = objectMap;
    }

    public void setAccessUser(AccessUser accessUser) {
        this.accessUser = accessUser;
    }

    public void setFormRemoveItemAction(String formRemoveItemAction) {
        this.formRemoveItemAction = formRemoveItemAction;
    }

    public void setColumnHeaders(List<String> columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public void setEmptyTableRowKey(String emptyTableRowKey) {
        this.emptyTableRowKey = emptyTableRowKey;
    }

    public Map<String, String> getFormHiddenVariableMap() {
        return this.formHiddenVariableMap;
    }

    public void setFormRowIdName(String formRowIdName) {
        this.formRowIdName = formRowIdName;
    }
}

