/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TableHeaderTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.hardware.HardwareListTemplate;
import com.kwoksys.action.issues.IssueSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.core.CompanyUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Company;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.SystemService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.Arrays;
import java.util.List;

public class IssueRelationshipAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser accessUser = this.requestContext.getUser();
        Integer issueId = this.requestContext.getParameter("issueId");
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        Issue issue = issueService.getIssue(issueId);
        SystemService systemService = ServiceProvider.getSystemService(this.requestContext);
        List<Integer> types = Arrays.asList(ObjectTypes.COMPANY, ObjectTypes.HARDWARE, ObjectTypes.SOFTWARE);
        List<Integer> linkedTypes = Arrays.asList(ObjectTypes.ISSUE);
        int relationshipCount = systemService.getObjectMapCount(types, issueId, linkedTypes);
        String hwOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "hwOrderBy", "HARDWARE_ORDER_BY", "hardware_name");
        String hwOrder = SessionManager.getOrSetAttribute(this.requestContext, "hwOrder", "HARDWARE_ORDER", "asc");
        List<String> hwColumnHeaders = HardwareUtils.getColumnHeaderList();
        QueryCriteria query = new QueryCriteria();
        if (HardwareUtils.isSortableColumn(hwOrderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(hwOrderBy), hwOrder);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        HardwareListTemplate listTemplate = standardTemplate.addTemplate(new HardwareListTemplate("_hardware"));
        listTemplate.setHardwareList(issueService.getIssueHardwareList(new QueryCriteria(), issue.getId()));
        listTemplate.setColspan(hwColumnHeaders.size());
        listTemplate.setCounter(new Counter());
        TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate("_hardware"));
        empty.setColSpan(hwColumnHeaders.size());
        empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.hardwareList.emptyTableMessage"));
        TableHeaderTemplate tableHeader = standardTemplate.addTemplate(new TableHeaderTemplate("_hardware"));
        tableHeader.setColumnList(hwColumnHeaders);
        tableHeader.setSortableColumnList(HardwareUtils.getSortableColumns());
        tableHeader.setColumnPath(AppPaths.ISSUES_RELATIONSHIP + "?issueId=" + issueId);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setOrderBy(hwOrderBy);
        tableHeader.setOrderByParamName("hwOrderBy");
        tableHeader.setOrderParamName("hwOrder");
        tableHeader.setOrder(hwOrder);
        String swOrderBy = SessionManager.getOrSetAttribute(this.requestContext, "swOrderBy", "SOFTWARE_ORDER_BY", "software_name");
        String swOrder = SessionManager.getOrSetAttribute(this.requestContext, "swOrder", "SOFTWARE_ORDER", "asc");
        QueryCriteria swQuery = new QueryCriteria();
        if (SoftwareUtils.isSortableColumn(swOrderBy)) {
            swQuery.addSortColumn(SoftwareQueries.getOrderByColumn(swOrderBy), swOrder);
        }
        List<Software> softwareList = issueService.getIssueSoftwareList(swQuery, issue.getId());
        List<DataRow> formattedList = SoftwareUtils.formatSoftwareList(this.requestContext, softwareList, new Counter());
        TableTemplate swTableTemplate = standardTemplate.addTemplate(new TableTemplate("_software"));
        swTableTemplate.setDataList(formattedList);
        swTableTemplate.setColumnHeaders(SoftwareUtils.getColumnHeaderList());
        swTableTemplate.setColumnPath(AppPaths.ISSUES_RELATIONSHIP + "?issueId=" + issueId);
        swTableTemplate.setSortableColumnHeaders(SoftwareUtils.getSortableColumns());
        swTableTemplate.setColumnTextKey("common.column.");
        swTableTemplate.setEmptyRowMsgKey("itMgmt.softwareList.emptyTableMessage");
        swTableTemplate.setOrderBy(swOrderBy);
        swTableTemplate.setOrder(swOrder);
        swTableTemplate.setOrderByParamName("swOrderBy");
        swTableTemplate.setOrderParamName("swOrder");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "cOrderBy", "COMPANIES_ORDER_BY", "company_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "cOrder", "COMPANIES_ORDER", "asc");
        query = new QueryCriteria();
        if (Company.isSortableCompanyColumn(orderBy)) {
            query.addSortColumn(ContactQueries.getOrderByColumn(orderBy), order);
        }
        List<Company> companyDataset = issueService.getIssueCompanyList(query, issue.getId());
        List<DataRow> dataList = CompanyUtils.formatCompanyList(this.requestContext, companyDataset, new Counter());
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate("_companies"));
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(ConfigManager.app.getContactsCompanyColumnList());
        tableTemplate.setSortableColumnHeaders(Company.getSortableCompanyColumnList());
        tableTemplate.setColumnPath(AppPaths.ISSUES_RELATIONSHIP + "?issueId=" + issueId);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setOrderByParamName("cOrderBy");
        tableTemplate.setOrderParamName("cOrder");
        tableTemplate.setEmptyRowMsgKey("contactMgmt.companyList.emptyTableMessage");
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("issueMgmt.issueDetail.title", new Object[]{issue.getSubject()});
        if (Access.hasPermission(accessUser, AppPaths.ISSUES_LIST)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.ISSUES_LIST);
            link.setTitleKey("issueMgmt.cmd.issueList");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(IssueUtils.getIssueTabs(this.requestContext, issue, relationshipCount));
        tabs.setTabActive("rel");
        IssueSpecTemplate spec = standardTemplate.addTemplate(new IssueSpecTemplate(issue));
        spec.setHeaderText(issue.getSubject());
        return standardTemplate.findTemplate("standard_template");
    }
}

