/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.core.CalendarUtils;
import com.kwoksys.biz.admin.dao.AdminQueries;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IssueSearchTemplate
extends BaseTemplate {
    private String formAction;
    private boolean hideSearchButton;
    private String clearSearchLink;

    public IssueSearchTemplate() {
        super(IssueSearchTemplate.class);
    }

    @Override
    public void init() {
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        QueryCriteria userQuery = new QueryCriteria();
        userQuery.addSortColumn(AdminQueries.getOrderByColumn(AdminUtils.getUsernameSort()));
        SelectOneLabelValueBean selectOneLabel = new SelectOneLabelValueBean(this.requestContext);
        ArrayList<LabelValueBean> typeOptions = new ArrayList<LabelValueBean>();
        typeOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.selectType"), ""));
        typeOptions.addAll(new AttributeManager(this.requestContext).getAttrFieldOptionsCache(Attributes.ISSUE_TYPE));
        ArrayList<LabelValueBean> statusOptions = new ArrayList<LabelValueBean>();
        statusOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.selectStatus"), ""));
        statusOptions.addAll(new AttributeManager(this.requestContext).getAttrFieldOptionsCache(Attributes.ISSUE_STATUS));
        ArrayList<LabelValueBean> priorityOptions = new ArrayList<LabelValueBean>();
        priorityOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.selectPriority"), ""));
        priorityOptions.addAll(new AttributeManager(this.requestContext).getAttrFieldOptionsCache(Attributes.ISSUE_PRIORITY));
        ArrayList<LabelValueBean> resolutionOptions = new ArrayList<LabelValueBean>();
        resolutionOptions.add(new LabelValueBean(Localizer.getText(this.requestContext, "issues.index.selectResolution"), ""));
        resolutionOptions.addAll(new AttributeManager(this.requestContext).getAttrFieldOptionsCache(Attributes.ISSUE_RESOLUTION));
        ArrayList<LabelValueBean> assigneeOptions = new ArrayList<LabelValueBean>();
        assigneeOptions.add(selectOneLabel);
        for (AccessUser assignee : adminService.getUsers(userQuery)) {
            assigneeOptions.add(new LabelValueBean(AdminUtils.getSystemUsername(this.requestContext, assignee), String.valueOf(assignee.getId())));
        }
        List<LabelValueBean> submissionOptions = Arrays.asList(selectOneLabel, new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.submittedWithin.last1days"), "last1days"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.submittedWithin.last7days"), "last7days"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.submittedWithin.last14days"), "last14days"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.submittedWithin.last30days"), "last30days"));
        List<LabelValueBean> dueWithinOptions = Arrays.asList(selectOneLabel, new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.dueIn.1day"), "1day"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.dueIn.1week"), "7days"), new LabelValueBean(Localizer.getText(this.requestContext, "issueMgmt.index.dueIn.1month"), "30days"));
        this.request.setAttribute("typeOptions", typeOptions);
        this.request.setAttribute("statusOptions", statusOptions);
        this.request.setAttribute("priorityOptions", priorityOptions);
        this.request.setAttribute("resolutionOptions", resolutionOptions);
        this.request.setAttribute("IssueSearchTemplate_assigneeOptions", assigneeOptions);
        this.request.setAttribute("IssueSearchTemplate_submittedWithinOptions", submissionOptions);
        this.request.setAttribute("IssueSearchTemplate_dueWithinOptions", dueWithinOptions);
        this.request.setAttribute("monthOptions", CalendarUtils.getMonthOptions(this.requestContext));
        this.request.setAttribute("dateOptions", CalendarUtils.getDateOptions(this.requestContext));
        this.request.setAttribute("yearOptions", CalendarUtils.getPastYearOptions(this.requestContext));
        this.request.setAttribute("customFieldsOptions", new AttributeManager(this.requestContext).getCustomFieldOptions(ObjectTypes.ISSUE));
        if (!this.hideSearchButton) {
            this.clearSearchLink = new Link(this.requestContext).setAjaxPath(AppPaths.ISSUES_INDEX + "?cmd=clear").setTitleKey("common.form.clearCriteria").getString();
        }
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = AppPaths.ROOT + formAction;
    }

    public boolean getHideSearchButton() {
        return this.hideSearchButton;
    }

    public void setHideSearchButton(boolean hideSearchButton) {
        this.hideSearchButton = hideSearchButton;
    }

    public String getClearSearchLink() {
        return this.clearSearchLink;
    }
}

