/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.issues;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.Attributes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class IssueSpecTemplate
extends BaseTemplate {
    private String headerText;
    private Issue issue;
    private String subscribers;
    private boolean hasHtmlContent;
    private boolean defaultDisplayHtmlIssueEmail;
    private String showPlainTextLink;
    private String formattedDescription;

    public IssueSpecTemplate(Issue issue) {
        super(IssueSpecTemplate.class);
        this.issue = issue;
    }

    @Override
    public void init() {
    }

    @Override
    public String getJspPath() {
        return "/jsp/issues/IssueSpecTemplate.jsp";
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        AccessUser user = this.requestContext.getUser();
        AttributeManager attributeManager = new AttributeManager(this.requestContext);
        this.hasHtmlContent = IssueUtils.isHtmlEmail(this.issue.getDescription());
        boolean bl = this.defaultDisplayHtmlIssueEmail = this.hasHtmlContent && ConfigManager.app.isIssuesDefaultDisplayHtmlEmail();
        if (this.hasHtmlContent) {
            this.request.setAttribute("issueHtmlEmailPath", (Object)(AppPaths.ROOT + AppPaths.ISSUES_DETAIL + "?issueId=" + this.issue.getId() + "&cmd=" + "issueHtmlEmail"));
        }
        this.formattedDescription = HtmlUtils.formatMultiLineDisplay(this.issue.getDescription());
        this.showPlainTextLink = new Link(this.requestContext).setJavascript("App.issueDisplayText()").setTitleKey("issues.issueDetails.showPlainText").getString();
        boolean hasPermission = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        String assigneeName = IssueUtils.getAssigneeIconLink(this.requestContext, hasPermission, this.issue.getAssignee());
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        List<AccessUser> subscribeUsers = issueService.getSelectedSubscribers(this.issue.getId());
        ArrayList<String> list = new ArrayList<String>();
        for (AccessUser subscribeUser : subscribeUsers) {
            list.add(AdminUtils.getSystemUsername(this.requestContext, subscribeUser));
        }
        this.subscribers = StringUtils.join(list, ", ");
        this.request.setAttribute("TemplateIssueSpec_issue", (Object)this.issue);
        this.request.setAttribute("TemplateIssueSpec_issueAssignee", (Object)assigneeName);
        this.request.setAttribute("TemplateIssueSpec_issueCreatorInfo", (Object)WidgetUtils.formatCreatorInfo(this.requestContext, this.issue.getCreationDate(), this.issue.getCreator()));
        this.request.setAttribute("TemplateIssueSpec_issueModifierInfo", (Object)WidgetUtils.formatCreatorInfo(this.requestContext, this.issue.getModificationDate(), this.issue.getModifier()));
        this.request.setAttribute("TemplateIssueSpec_issueTypeName", (Object)attributeManager.getAttrFieldNameCache(Attributes.ISSUE_TYPE, this.issue.getType()));
        this.request.setAttribute("TemplateIssueSpec_issueStatusName", (Object)attributeManager.getAttrFieldNameCache(Attributes.ISSUE_STATUS, this.issue.getStatus()));
        this.request.setAttribute("TemplateIssueSpec_issuePriorityName", (Object)attributeManager.getAttrFieldNameCache(Attributes.ISSUE_PRIORITY, this.issue.getPriority()));
        this.request.setAttribute("TemplateIssueSpec_issueResolutionName", (Object)attributeManager.getAttrFieldNameCache(Attributes.ISSUE_RESOLUTION, this.issue.getResolution()));
        this.request.setAttribute("TemplateIssueSpec_issueSubscribers", (Object)this.subscribers);
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public boolean isHasHtmlContent() {
        return this.hasHtmlContent;
    }

    public String getShowPlainTextLink() {
        return this.showPlainTextLink;
    }

    public String getFormattedDescription() {
        return this.formattedDescription;
    }

    public boolean isDefaultDisplayHtmlIssueEmail() {
        return this.defaultDisplayHtmlIssueEmail;
    }
}

