/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.kb.ArticleForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.CkeditorHelper;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;

public class ArticleAddAction
extends Action2 {
    public String add() throws Exception {
        ArticleForm actionForm = this.getBaseForm(ArticleForm.class);
        actionForm.setId("articleAddForm");
        Article article = new Article();
        if (actionForm.getCategoryId() != null) {
            article.setCategoryId(actionForm.getCategoryId());
        }
        if (!actionForm.isResubmit()) {
            actionForm.setArticle(article);
        }
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(KbQueries.getOrderByColumn("category_name"));
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        ArrayList<LabelValueBean> categoryIdOptions = new ArrayList<LabelValueBean>();
        for (Category category : kbService.getCategories(query)) {
            categoryIdOptions.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.KB_ARTICLE_ADD_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.KB_ARTICLE_ADD);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, actionForm.getCategoryId() != 0 ? AppPaths.KB_ARTICLE_LIST + "?categoryId=" + actionForm.getCategoryId() : AppPaths.KB_INDEX).getString());
        this.request.setAttribute("categoryIdOptions", categoryIdOptions);
        boolean isWikiType = KbUtils.isWikiType(actionForm.getArticleSyntax());
        String articleText = actionForm.getArticleText();
        if (!isWikiType) {
            articleText = StringUtils.encodeCkeditorJs(articleText);
            this.request.setAttribute("language", (Object)CkeditorHelper.getLocaleKey(this.requestContext.getLocale()));
        }
        this.request.setAttribute("articleText", (Object)articleText);
        this.request.setAttribute("isWikiSyntax", (Object)isWikiType);
        this.request.setAttribute("articleSyntaxOptions", KbUtils.getArticleSyntaxOptions(this.requestContext, article));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.articleAdd.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        errorsTemplate.setMessageKey("kb.articleFile.ckeditor.upload.description");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        Article article = new Article();
        ArticleForm actionForm = this.saveActionForm(new ArticleForm());
        article.setName(actionForm.getArticleName());
        article.setContent(actionForm.getArticleText());
        article.setSyntaxType(actionForm.getArticleSyntax());
        article.setWikiNamespace(KbUtils.formatWikiNamespace(actionForm.getArticleSyntax(), actionForm.getArticleName()));
        article.setCategoryId(actionForm.getCategoryId());
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        ActionMessages errors = kbService.addArticle(article);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.KB_ARTICLE_ADD + "?" + "_error=true");
        }
        return this.redirect(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId());
    }
}

