/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.HeaderSimpleTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.core.FileUtils;
import com.kwoksys.biz.files.dao.FileQueries;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ArticleDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        Integer articleId = this.requestContext.getParameter("articleId");
        String articleWikiNamespace = this.requestContext.getParameterString("title");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        Article article = articleId != 0 ? kbService.getArticle(articleId) : kbService.getArticle(articleWikiNamespace);
        kbService.updateArticleViewCount(article);
        Category category = kbService.getCategory(article.getCategoryId());
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(FileQueries.getOrderByColumn("file_name"));
        List<File> files = kbService.getArticleFiles(query, article.getId());
        boolean ckeditorBrowse = !this.requestContext.getParameterString("CKEditor").isEmpty();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        boolean canDownloadFile = Access.hasPermission(user, AppPaths.KB_ARTICLE_FILE_DOWNLOAD);
        if (ckeditorBrowse) {
            HeaderSimpleTemplate header = standardTemplate.addTemplate(new HeaderSimpleTemplate());
            header.setTitleText(Localizer.getText(this.requestContext, "files.fileAttachmentTab"));
            header.setThemeTitleText(Localizer.getText(this.requestContext, "files.fileAttachmentTab"));
            String ckeditorFuncNum = this.requestContext.getParameterString("CKEditorFuncNum");
            this.request.setAttribute("ckeditorFuncNum", (Object)ckeditorFuncNum);
            ArrayList formattedFiles = new ArrayList();
            for (File file : files) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("file", file);
                map.put("fileName", Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), AppPaths.KB_ARTICLE_FILE_DOWNLOAD + "?articleId=" + articleId + "&fileId=" + file.getId()).getString());
                map.put("filesize", FileUtils.formatFileSize(this.requestContext, file.getSize()));
                map.put("filePath", AppPaths.KB_ARTICLE_FILE_DOWNLOAD_RELATIVE + "?articleId=" + articleId + "&fileId=" + file.getId());
                formattedFiles.add(map);
            }
            this.request.setAttribute("files", formattedFiles);
            return standardTemplate.findTemplate("files");
        }
        boolean canDeleteFile = Access.hasPermission(user, AppPaths.KB_ARTICLE_FILE_DELETE);
        if (!files.isEmpty()) {
            ArrayList formattedFiles = new ArrayList();
            for (File file : files) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("file", file);
                map.put("fileName", Links.getFileIconLink(this.requestContext, canDownloadFile, file.getLogicalName(), AppPaths.KB_ARTICLE_FILE_DOWNLOAD + "?articleId=" + articleId + "&fileId=" + file.getId()).getString());
                map.put("filesize", FileUtils.formatFileSize(this.requestContext, file.getSize()));
                if (canDeleteFile) {
                    map.put("deleteFilePath", new Link(this.requestContext).setAjaxPath(AppPaths.KB_ARTICLE_FILE_DELETE + "?articleId=" + articleId + "&fileId=" + file.getId()).setTitleKey("common.action.Delete"));
                }
                formattedFiles.add(map);
            }
            standardTemplate.setAttribute("files", formattedFiles);
        }
        standardTemplate.setAttribute("article", article);
        standardTemplate.setAttribute("articleText", KbUtils.formatContent(this.requestContext, article));
        standardTemplate.setAttribute("articleCreator", AdminUtils.getSystemUsername(this.requestContext, article.getCreator()));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        KbUtils.generatePath(header, this.requestContext, category);
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.KB_ARTICLE_EDIT + "?articleId=" + article.getId());
            link.setTitleKey("kb.cmd.articleEdit");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_PRINT)) {
            link = new Link(this.requestContext);
            link.setExportPath(AppPaths.KB_ARTICLE_PRINT + "?articleId=" + article.getId());
            link.setTitleKey("kb.cmd.articlePrint");
            link.setInlineImage(Image.getInstance().getPrintIcon());
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_FILE_ADD)) {
            link = new Link(this.requestContext);
            link.setTitleKey("files.fileAttach");
            if (fileService.isDirectoryExist(ConfigManager.file.getKbFileRepositoryLocation())) {
                link.setAjaxPath(AppPaths.KB_ARTICLE_FILE_ADD + "?articleId=" + articleId);
                link.setInlineImage(Image.getInstance().getFileAddIcon());
            } else {
                link.setInlineImage(Image.getInstance().getWarning(Localizer.getText(this.requestContext, "files.warning.invalidPath")));
            }
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_DELETE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.KB_ARTICLE_DELETE + "?articleId=" + article.getId());
            link.setTitleKey("kb.cmd.articleDelete");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

