/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.kb.ArticleForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.CkeditorHelper;
import com.kwoksys.framework.util.StringUtils;
import java.util.ArrayList;

public class ArticleEditAction
extends Action2 {
    public String edit() throws Exception {
        AccessUser user = this.requestContext.getUser();
        ArticleForm actionForm = this.getBaseForm(ArticleForm.class);
        actionForm.setId("articleEditForm");
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Article article = kbService.getArticle(actionForm.getArticleId());
        if (!actionForm.isResubmit()) {
            actionForm.setArticle(article);
        }
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(KbQueries.getOrderByColumn("category_name"));
        ArrayList<LabelValueBean> categoryIdOptions = new ArrayList<LabelValueBean>();
        for (Category category : kbService.getCategories(query)) {
            categoryIdOptions.add(new LabelValueBean(category.getName(), String.valueOf(category.getId())));
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.KB_ARTICLE_EDIT_2);
        standardTemplate.setPathAttribute("formThisAction", AppPaths.KB_ARTICLE_EDIT + "?articleId=" + article.getId());
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId()).getString());
        this.request.setAttribute("categoryIdOptions", categoryIdOptions);
        boolean isWikiType = KbUtils.isWikiType(actionForm.getArticleSyntax());
        String articleText = actionForm.getArticleText();
        if (!isWikiType) {
            articleText = StringUtils.encodeCkeditorJs(articleText);
            this.request.setAttribute("language", (Object)CkeditorHelper.getLocaleKey(this.requestContext.getLocale()));
            if (fileService.isDirectoryExist(ConfigManager.file.getKbFileRepositoryLocation())) {
                standardTemplate.setPathAttribute("fileBrowseUrl", AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId() + "&CKEditor=1");
                if (Access.hasPermission(user, AppPaths.KB_ARTICLE_FILE_ADD)) {
                    standardTemplate.setPathAttribute("fileUploadUrl", AppPaths.KB_ARTICLE_FILE_ADD_2 + "?articleId=" + article.getId() + "&CKEditor=1");
                }
            }
        }
        this.request.setAttribute("articleText", (Object)articleText);
        this.request.setAttribute("isWikiSyntax", (Object)isWikiType);
        this.request.setAttribute("articleSyntaxOptions", KbUtils.getArticleSyntaxOptions(this.requestContext, article));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.articleEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        ArticleForm actionForm = this.saveActionForm(new ArticleForm());
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Article article = kbService.getArticle(actionForm.getArticleId());
        article.setName(actionForm.getArticleName());
        article.setContent(actionForm.getArticleText());
        article.setSyntaxType(actionForm.getArticleSyntax());
        article.setWikiNamespace(KbUtils.formatWikiNamespace(actionForm.getArticleSyntax(), actionForm.getArticleName()));
        article.setCategoryId(actionForm.getCategoryId());
        ActionMessages errors = kbService.updateArticle(article);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.KB_ARTICLE_EDIT + "?articleId=" + article.getId() + "&" + "_error=true");
        }
        return this.redirect(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId());
    }
}

