/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.files.FileAddTemplate;
import com.kwoksys.action.files.FileDeleteTemplate;
import com.kwoksys.action.files.FileUploadForm;
import com.kwoksys.action.kb.ArticleSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.files.FileService;
import com.kwoksys.biz.files.dto.File;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.kb.dto.ArticleFile;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.exceptions.ObjectNotFoundException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import java.io.FileNotFoundException;

public class ArticleFileAction
extends Action2 {
    public String add() throws Exception {
        Integer articleId = this.requestContext.getParameter("articleId");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Article article = kbService.getArticle(articleId);
        Category category = kbService.getCategory(article.getCategoryId());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        KbUtils.generatePath(header, this.requestContext, category);
        standardTemplate.addTemplate(new ArticleSpecTemplate(article));
        FileUploadForm actionForm = this.getBaseForm(FileUploadForm.class);
        FileAddTemplate fileAdd = standardTemplate.addTemplate(new FileAddTemplate(actionForm));
        fileAdd.setFileName(this.requestContext.getParameterString("fileName0"));
        fileAdd.setFormAction(AppPaths.KB_ARTICLE_FILE_ADD_2 + "?articleId=" + articleId);
        fileAdd.setFormCancelAction(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + articleId);
        fileAdd.getErrorsTemplate().setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        boolean ckeditorUpload = !this.requestContext.getParameterString("CKEditor").isEmpty();
        FileUploadForm actionForm = new FileUploadForm();
        actionForm.setFormUploadFieldName(ckeditorUpload ? "upload" : "file0");
        actionForm = this.saveActionForm(actionForm);
        Integer articleId = this.requestContext.getParameter("articleId");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Article article = kbService.getArticle(articleId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        ArticleFile file = new ArticleFile(articleId);
        ActionMessages errors = fileService.addFile(file, actionForm);
        if (ckeditorUpload) {
            this.requestContext.getRequest().setAttribute("fileDownloadPath", (Object)(AppPaths.KB_ARTICLE_FILE_DOWNLOAD_RELATIVE + "?articleId=" + articleId + "&fileId=" + file.getId()));
            return "success";
        }
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.redirect(AppPaths.KB_ARTICLE_FILE_ADD + "?" + "_error=true" + "&articleId=" + articleId);
        }
        return this.redirect(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId());
    }

    public String delete() throws Exception {
        Integer articleId = this.requestContext.getParameter("articleId");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Article article = kbService.getArticle(articleId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = kbService.getArticleFile(articleId, fileId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        Category category = kbService.getCategory(article.getCategoryId());
        KbUtils.generatePath(header, this.requestContext, category);
        standardTemplate.addTemplate(new ArticleSpecTemplate(article));
        FileDeleteTemplate fileDelete = standardTemplate.addTemplate(new FileDeleteTemplate());
        fileDelete.setFile(file);
        fileDelete.setFormAction(AppPaths.KB_ARTICLE_FILE_DELETE_2 + "?articleId=" + articleId + "&fileId=" + file.getId());
        fileDelete.setFormCancelAction(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + articleId);
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String delete2() throws Exception {
        Integer articleId = this.requestContext.getParameter("articleId");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        kbService.getArticle(articleId);
        Integer fileId = this.requestContext.getParameter("fileId");
        File file = kbService.getArticleFile(articleId, fileId);
        FileService fileService = ServiceProvider.getFileService(this.requestContext);
        fileService.deleteFile(file);
        return this.ajaxUpdateView(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + articleId);
    }

    public String download() throws Exception {
        ResponseContext responseContext = new ResponseContext(this.response);
        try {
            KbService kbService = ServiceProvider.getKbService(this.requestContext);
            Integer articleId = this.requestContext.getParameter("articleId");
            kbService.getArticle(articleId);
            Integer fileId = this.requestContext.getParameter("fileId");
            File file = kbService.getArticleFile(articleId, fileId);
            FileService fileService = ServiceProvider.getFileService(this.requestContext);
            fileService.download(responseContext, file);
        }
        catch (ObjectNotFoundException e) {
            throw new FileNotFoundException();
        }
        return null;
    }
}

