/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.kb.ArticleSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.kb.KbSearch;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ArticleListAction
extends Action2 {
    public String execute() throws Exception {
        ArticleSearchForm actionForm = this.getBaseForm(ArticleSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Category category = kbService.getCategory(actionForm.getCategoryId());
        KbSearch kbSearch = new KbSearch();
        kbSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(kbSearch);
        query.addSortColumn(KbQueries.getOrderByColumn("article_name"));
        boolean hasArticleAccess = Access.hasPermission(user, AppPaths.KB_ARTICLE_DETAIL);
        ArrayList articles = new ArrayList();
        List<String> includeColumns = Arrays.asList(ConfigManager.app.getKbArticleColumns());
        for (Article article : kbService.getArticles(query)) {
            HashMap<String, String> map = new HashMap<String, String>();
            Link link = new Link(this.requestContext);
            link.setTitle(article.getName());
            if (hasArticleAccess) {
                link.setAjaxPath(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId());
            }
            map.put("articleName", link.getString());
            if (includeColumns.contains("article_view_count")) {
                map.put("viewCount", String.valueOf(article.getViewCount()));
            }
            articles.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("articles", articles);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.articleList.header");
        KbUtils.generatePath(header, this.requestContext, category);
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.KB_ARTICLE_ADD + "?categoryId=" + actionForm.getCategoryId()).setTitleKey("kb.cmd.articleAdd"));
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

