/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.kb.ArticleSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.kb.KbSearch;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.Article;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeFieldIds;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class ArticleSearchAction
extends Action2 {
    public String execute() throws Exception {
        ArticleSearchForm actionForm = this.getSessionBaseForm(ArticleSearchForm.class);
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getKbArticleNumberOfSearchResults());
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        KbSearch kbSearch = new KbSearch();
        kbSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(kbSearch);
        query.addSortColumn(KbQueries.getOrderByColumn("article_name"));
        query.setLimit(rowLimit, rowStart);
        ArrayList articles = new ArrayList();
        int rowCount = kbService.getArticlesCount(query);
        if (rowCount != 0) {
            for (Article article : kbService.getArticles(query)) {
                HashMap<String, String> map = new HashMap<String, String>();
                String articleText = KbUtils.truncateBodyText(HtmlUtils.removeHtmlTags(article.getContent()));
                if (article.getSyntaxType().equals(AttributeFieldIds.KB_ARTICLE_SYNTAX_MEDIAWIKI)) {
                    articleText = HtmlUtils.encode(articleText);
                }
                map.put("articleText", articleText);
                map.put("articleCreator", AdminUtils.getSystemUsername(this.requestContext, article.getCreator()));
                map.put("articleCreationDate", article.getCreationDate());
                map.put("articleDetailsLink", new Link(this.requestContext).setAjaxPath(AppPaths.KB_ARTICLE_DETAIL + "?articleId=" + article.getId()).setStyleClass("h2").setTitle(article.getName()).getString());
                articles.add(map);
            }
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("articles", articles);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.articleSearchResults.header");
        header.setTitleClassNoLine();
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setPath(AppPaths.KB_ARTICLE_SEARCH + "?rowStart=");
        return standardTemplate.findTemplate("standard_template");
    }
}

