/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.kb.CategoryForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.KbUtils;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.kb.dto.KBCategory;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class CategoryAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        List<String> columnHeaders = KbUtils.getCategoryColumnHeaderList();
        QueryCriteria query = new QueryCriteria();
        if (KbUtils.isSortableCategoryColumn("category_name")) {
            query.addSortColumn(KbQueries.getOrderByColumn("category_name"));
        }
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        List<Category> categoryDataset = kbService.getCategories(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.categoryList.header");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.KB_CATEGORY_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setTitleKey("kb.cmd.categoryAdd").setAjaxPath(AppPaths.KB_CATEGORY_ADD));
        }
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnPath(AppPaths.KB_CATEGORY_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        if (!categoryDataset.isEmpty()) {
            boolean canEditCategory = user.hasPermission(AppPaths.KB_CATEGORY_EDIT);
            Counter counter = new Counter();
            for (Category category : categoryDataset) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("category_name")) {
                        columns.add(HtmlUtils.encode(category.getName()));
                        continue;
                    }
                    if (column.equals("category_description")) {
                        columns.add(HtmlUtils.formatMultiLineDisplay(category.getDescription()));
                        continue;
                    }
                    if (column.equals("article_object_count")) {
                        columns.add(String.valueOf(category.getCountObjects()));
                        continue;
                    }
                    if (column.equals("category_actions")) {
                        if (canEditCategory) {
                            Link link = new Link(this.requestContext).setAjaxPath(AppPaths.KB_CATEGORY_EDIT + "?categoryId=" + category.getId()).setTitleKey("common.action.Edit");
                            columns.add(link.getString());
                            continue;
                        }
                        columns.add("");
                        continue;
                    }
                    if (!column.equals("rownum")) continue;
                    columns.add(counter.incr() + ".");
                }
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Category category = new Category();
        CategoryForm actionForm = this.getBaseForm(CategoryForm.class);
        actionForm.setId("kbCategoryAddForm");
        if (!actionForm.isResubmit()) {
            actionForm.setCategory(category);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.KB_CATEGORY_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.KB_CATEGORY_LIST).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.categoryAdd.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        CategoryForm actionForm = this.saveActionForm(new CategoryForm());
        KBCategory category = new KBCategory();
        category.setName(actionForm.getCategoryName());
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        ActionMessages errors = kbService.addCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.KB_CATEGORY_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.KB_CATEGORY_LIST);
    }

    public String edit() throws Exception {
        CategoryForm actionForm = this.getBaseForm(CategoryForm.class);
        actionForm.setId("kbCategoryEditForm");
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Category category = kbService.getCategory(actionForm.getCategoryId());
        if (!actionForm.isResubmit()) {
            actionForm.setCategory(category);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.KB_CATEGORY_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.KB_CATEGORY_LIST).getString());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.categoryEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        CategoryForm actionForm = this.saveActionForm(new CategoryForm());
        Integer categoryId = actionForm.getCategoryId();
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        Category category = kbService.getCategory(categoryId);
        category.setName(actionForm.getCategoryName());
        ActionMessages errors = kbService.updateCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.KB_CATEGORY_EDIT + "?categoryId=" + category.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.KB_CATEGORY_LIST);
    }
}

