/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.kb;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.kb.ArticleSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.kb.KbService;
import com.kwoksys.biz.kb.dao.KbQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.ui.SelectOneLabelValueBean;
import java.util.ArrayList;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        this.getSessionBaseForm(ArticleSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(KbQueries.getOrderByColumn("category_name"));
        ArrayList<SelectOneLabelValueBean> categoryOptions = new ArrayList<SelectOneLabelValueBean>();
        categoryOptions.add(new SelectOneLabelValueBean(this.requestContext));
        KbService kbService = ServiceProvider.getKbService(this.requestContext);
        ArrayList<String> categories = new ArrayList<String>();
        for (Category category : kbService.getCategories(query)) {
            if (category.getCountObjects() <= 0) continue;
            categories.add(new Link(this.requestContext).setAjaxPath(AppPaths.KB_ARTICLE_LIST + "?cmd=search&categoryId=" + category.getId()).setTitle(category.getName() + " (" + category.getCountObjects() + ")").getString());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("articleSearchPath", AppPaths.ROOT + AppPaths.KB_ARTICLE_SEARCH);
        standardTemplate.setAttribute("categories", categories);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("kb.index.header");
        header.setTitleClassNoLine();
        if (Access.hasPermission(user, AppPaths.KB_CATEGORY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.KB_CATEGORY_LIST);
            link.setTitleKey("kb.categoryList.header");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.KB_ARTICLE_ADD)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.KB_ARTICLE_ADD);
            link.setTitleKey("kb.cmd.articleAdd");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

