/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.portal.SiteCategoryForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.PortalUtils;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.SiteCategory;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dto.Category;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class SiteCategoryAction
extends Action2 {
    public String list() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Counter counter = new Counter();
        List<String> columnHeaders = PortalUtils.getCategoryColumnHeaderList();
        QueryCriteria query = new QueryCriteria();
        if (PortalUtils.isSortableCategoryColumn("category_name")) {
            query.addSortColumn(PortalQueries.getOrderByColumn("category_name"));
        }
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        List<Category> categories = portalService.getCategories(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("portal.siteCategoryList.header");
        header.setTitleClassNoLine();
        if (user.hasPermission(AppPaths.PORTAL_CATEGORY_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.PORTAL_CATEGORY_ADD).setTitleKey("portal.siteCategoryAdd.header"));
        }
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnPath(AppPaths.PORTAL_CATEGORY_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        if (!categories.isEmpty()) {
            boolean canEditCategory = user.hasPermission(AppPaths.PORTAL_CATEGORY_EDIT);
            for (Category category : categories) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("category_name")) {
                        columns.add(HtmlUtils.encode(category.getName()));
                        continue;
                    }
                    if (column.equals("category_description")) {
                        columns.add(HtmlUtils.formatMultiLineDisplay(category.getDescription()));
                        continue;
                    }
                    if (column.equals("category_actions")) {
                        if (canEditCategory) {
                            Link link = new Link(this.requestContext).setTitleKey("common.action.Edit").setAjaxPath(AppPaths.PORTAL_CATEGORY_EDIT + "?categoryId=" + category.getId());
                            columns.add(link.getString());
                            continue;
                        }
                        columns.add("");
                        continue;
                    }
                    if (!column.equals("rownum")) continue;
                    columns.add(counter.incr() + ".");
                }
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Category category = new Category();
        SiteCategoryForm actionForm = this.getBaseForm(SiteCategoryForm.class);
        actionForm.setId("siteCategoryAddForm");
        if (!actionForm.isResubmit()) {
            actionForm.setCategoryName(category.getName());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.PORTAL_CATEGORY_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.PORTAL_CATEGORY_LIST).getString());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("portal.siteCategoryAdd.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        SiteCategoryForm actionForm = this.saveActionForm(new SiteCategoryForm());
        SiteCategory category = new SiteCategory();
        category.setName(actionForm.getCategoryName());
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        ActionMessages errors = portalService.addCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.PORTAL_CATEGORY_ADD + "?" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.PORTAL_CATEGORY_LIST);
    }

    public String edit() throws Exception {
        SiteCategoryForm actionForm = this.getBaseForm(SiteCategoryForm.class);
        actionForm.setId("siteCategoryEditForm");
        Integer categoryId = actionForm.getCategoryId();
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        Category category = portalService.getCategory(categoryId);
        if (!actionForm.isResubmit()) {
            actionForm.setCategoryName(category.getName());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("categoryId", categoryId);
        standardTemplate.setPathAttribute("formAction", AppPaths.PORTAL_CATEGORY_EDIT_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.PORTAL_CATEGORY_LIST).getString());
        HeaderTemplate headerTemplate = standardTemplate.getHeaderTemplate();
        headerTemplate.setTitleKey("portal.siteCategoryEdit.header");
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        SiteCategoryForm actionForm = this.saveActionForm(new SiteCategoryForm());
        Integer categoryId = actionForm.getCategoryId();
        Category category = portalService.getCategory(categoryId);
        category.setName(actionForm.getCategoryName());
        ActionMessages errors = portalService.editCategory(category);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.PORTAL_CATEGORY_EDIT + "?categoryId=" + categoryId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.PORTAL_CATEGORY_LIST);
    }
}

