/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.portal.SiteSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;

public class SiteDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        Integer siteId = this.requestContext.getParameter("siteId");
        Site site = portalService.getSite(siteId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("admin.portalSiteDetail.header");
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_EDIT)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.PORTAL_SITE_EDIT + "?siteId=" + site.getId());
            link.setTitleKey("admin.portalSiteEdit.title");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_DELETE)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.PORTAL_SITE_DELETE + "?siteId=" + site.getId());
            link.setTitleKey("admin.portalSiteDelete.title");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.PORTAL_SITE_LIST);
            link.setTitleKey("admin.cmd.portalSiteList");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new SiteSpecTemplate(site));
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

