/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class SiteListAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = SessionManager.getOrSetAttribute(this.requestContext, "orderBy", "SITES_ORDER_BY", "site_name");
        String order = SessionManager.getOrSetAttribute(this.requestContext, "order", "SITES_ORDER", "asc");
        int rowStart = 0;
        if (!cmd.isEmpty() || rowCmd.equals("showAll")) {
            this.request.getSession().setAttribute("SITES_ROW_START", (Object)rowStart);
        } else {
            rowStart = SessionManager.getOrSetAttribute(this.requestContext, "rowStart", "SITES_ROW_START", rowStart);
        }
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getPortalNumberOfSitesToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        QueryCriteria query = new QueryCriteria();
        query.setLimit(rowLimit, rowStart);
        if (Site.isSortableColumn(orderBy)) {
            query.addSortColumn(PortalQueries.getOrderByColumn(orderBy), order);
        }
        List<String> columnHeaders = Site.getColumnHeader();
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("admin.portalSiteList.header");
        header.setTitleClassNoLine();
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_ADD)) {
            header.addHeaderCmds(new Link(this.requestContext).setAjaxPath(AppPaths.PORTAL_SITE_ADD).setTitleKey("admin.portalSiteAdd.title"));
        }
        int rowCount = portalService.getSiteCount(query);
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setInfoText("");
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "admin.portalSiteList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.PORTAL_SITE_LIST + "?rowCmd=showAll");
        nav.setPath(AppPaths.PORTAL_SITE_LIST + "?rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setSortableColumnHeaders(Site.getSortableColumnList());
        tableTemplate.setColumnPath(AppPaths.PORTAL_SITE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setEmptyRowMsgKey("admin.portalSiteList.emptyTableMessage");
        List<Site> sites = portalService.getSites(query);
        if (!sites.isEmpty()) {
            Counter counter = new Counter(rowStart);
            for (Site site : sites) {
                ArrayList<String> columns = new ArrayList<String>();
                for (String column : columnHeaders) {
                    if (column.equals("site_name")) {
                        Link link = new Link(this.requestContext).setAjaxPath(AppPaths.PORTAL_SITE_DETAIL + "?siteId=" + site.getId()).setTitle(site.getName());
                        columns.add(link.getString());
                        continue;
                    }
                    if (column.equals("site_placement")) {
                        columns.add(Localizer.getText(this.requestContext, Site.getSitePlacementMessageKey(site.getPlacement())));
                        continue;
                    }
                    if (column.equals("site_support_iframe")) {
                        columns.add(Localizer.getText(this.requestContext, Site.getSupportIframe(site.getSupportIframe())));
                        continue;
                    }
                    if (column.equals("rownum")) {
                        columns.add(String.valueOf(counter.incr()));
                        continue;
                    }
                    if (!column.equals("site_path")) continue;
                    columns.add(HtmlUtils.encode(site.getPath()));
                }
                tableTemplate.addRow(columns);
            }
        }
        return standardTemplate.findTemplate("standard_autogen_template");
    }
}

