/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.SiteSearch;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SiteListIndexAction
extends Action2 {
    public String execute() throws Exception {
        Link link;
        AccessUser user = this.requestContext.getUser();
        SiteSearch siteSearch = new SiteSearch();
        siteSearch.put("shownOnList", "");
        QueryCriteria query = new QueryCriteria(siteSearch);
        query.addSortColumn(PortalQueries.getOrderByColumn("category_name"));
        query.addSortColumn(PortalQueries.getOrderByColumn("site_name"));
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        List<Site> sites = portalService.getSites(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("toggleFrameLink", new Link(this.requestContext).setJavascript("Js.Display.toggle('div1')").setTitleKey("portal.siteList.toggleDiv"));
        if (!sites.isEmpty()) {
            HashMap categoriesMap = new HashMap();
            for (Site site : sites) {
                HashMap<Integer, String> categoryMap = new HashMap<Integer, String>();
                categoryMap.put(site.getCategoryId(), site.getCategoryName());
                ArrayList<String> list = (ArrayList<String>)categoriesMap.get(categoryMap);
                if (list == null) {
                    list = new ArrayList<String>();
                    categoriesMap.put(categoryMap, list);
                }
                list.add(Links.getPortalSiteLink(this.requestContext, site).getString());
            }
            standardTemplate.setAttribute("dataList", categoriesMap);
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(1);
            empty.setRowText(Localizer.getText(this.requestContext, "portal.siteList.emptyTableMessage"));
        }
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.PORTAL_SITE_LIST);
            link.setTitleKey("admin.index.portalSiteList");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.PORTAL_CATEGORY_LIST)) {
            link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.PORTAL_CATEGORY_LIST);
            link.setTitleKey("portal.siteCategoryList.header");
            header.addHeaderCmds(link);
        }
        if (Access.hasPermission(user, AppPaths.PORTAL_SITE_LIST_RSS)) {
            link = new Link(this.requestContext);
            link.setAppPath(AppPaths.PORTAL_SITE_LIST_RSS);
            link.setTitleKey("portal.cmd.rssFeedSubscribe");
            link.setInlineImage(Image.getInstance().getRssFeedIcon());
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

