/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.portal.PortalService;
import com.kwoksys.biz.portal.SiteSearch;
import com.kwoksys.biz.portal.dao.PortalQueries;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.parsers.rss.RssModel;
import com.kwoksys.framework.parsers.rss.RssModelHelper;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.util.HtmlUtils;

public class SiteListRssAction
extends Action2 {
    public String execute() throws Exception {
        RssModel rssModel = new RssModel();
        rssModel.setTitle(Localizer.getText(this.requestContext, "portal.siteList.header"));
        rssModel.setLink(ConfigManager.system.getAppUrl());
        rssModel.setDescription(Localizer.getText(this.requestContext, "rss.description"));
        rssModel.setLanguage("en-us");
        SiteSearch siteSearch = new SiteSearch();
        siteSearch.put("shownOnList", "");
        QueryCriteria query = new QueryCriteria(siteSearch);
        query.addSortColumn(PortalQueries.getOrderByColumn("site_name"));
        PortalService portalService = ServiceProvider.getPortalService(this.requestContext);
        for (Site site : portalService.getSites(query)) {
            RssModel.Item item = new RssModel.Item(rssModel);
            item.setTitle(site.getName());
            item.setLink(HtmlUtils.encode(site.getPath()));
            rssModel.addItem(item);
        }
        this.response.setContentType("text/xml");
        RssModelHelper helper = new RssModelHelper();
        helper.modelToXml(rssModel);
        this.response.getWriter().print(helper.getXmlString());
        return null;
    }
}

