/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.portal;

import com.kwoksys.action.common.template.DetailTableTemplate;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.portal.dto.Site;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.framework.exceptions.DatabaseException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.ui.WidgetUtils;
import com.kwoksys.framework.util.HtmlUtils;

public class SiteSpecTemplate
extends BaseTemplate {
    private DetailTableTemplate detailTableTemplate = new DetailTableTemplate();
    private Site site;

    public SiteSpecTemplate(Site site) {
        super(SiteSpecTemplate.class);
        this.site = site;
    }

    @Override
    public void init() {
        this.addTemplate(this.detailTableTemplate);
    }

    @Override
    public void applyTemplate() throws DatabaseException {
        DetailTableTemplate.Td td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_id");
        td.setValue(this.site.getId());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_name");
        td.setValue(HtmlUtils.encode(this.site.getName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_path");
        td.setValue(Links.getPortalSiteLink(this.requestContext, this.site).setTitle(this.site.getPath()).getString());
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_description");
        td.setValue(HtmlUtils.formatMultiLineDisplay(this.site.getDescription()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_category");
        td.setValue(HtmlUtils.encode(this.site.getCategoryName()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_placement");
        td.setValue(Localizer.getText(this.requestContext, Site.getSitePlacementMessageKey(this.site.getPlacement())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.site_support_iframe");
        td.setValue(Localizer.getText(this.requestContext, Site.getSupportIframe(this.site.getSupportIframe())));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.creator");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.site.getCreationDate(), this.site.getCreator()));
        td = this.detailTableTemplate.newTd();
        td.setHeaderKey("common.column.modifier");
        td.setValue(WidgetUtils.formatCreatorInfo(this.requestContext, this.site.getModificationDate(), this.site.getModifier()));
    }

    @Override
    public String getJspPath() {
        return "/jsp/portal/SiteSpecTemplate.jsp";
    }
}

