/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.contracts.ContractSearchForm;
import com.kwoksys.action.reports.ReportPreviewResultsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.contracts.ContractService;
import com.kwoksys.biz.contracts.core.ContractSearch;
import com.kwoksys.biz.contracts.core.ContractUtils;
import com.kwoksys.biz.contracts.dao.ContractQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.List;

public class ReportPreviewContractResultsAction
extends Action2 {
    public String execute() throws Exception {
        String reportType;
        ContractSearchForm actionForm = this.getSessionBaseForm(ContractSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(user, reportType = this.requestContext.getParameterString("reportType"))) {
            throw new AccessDeniedException();
        }
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = this.requestContext.getParameterString("orderBy", "contract_name");
        String order = this.requestContext.getParameterString("order");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getContractsRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        ContractService contractService = ServiceProvider.getContractService(this.requestContext);
        ContractSearch contractSearch = new ContractSearch(this.requestContext, "CONTRACT_REPORT_CRITERIA_MAP");
        contractSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(contractSearch);
        int rowCount = contractService.getContractCount(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : ConfigManager.app.getContractsExportColumns()) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        for (Attribute attr : new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.CONTRACT).values()) {
            preview.addReportColumnOptions(new LabelValueBean(attr.getName(), String.valueOf(attr.getId())));
        }
        for (String column : ContractUtils.getSortableColumns()) {
            preview.addSortColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "contracts.contractList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_CONTRACT_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_CONTRACT_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableHeader = standardTemplate.addTemplate(new TableTemplate());
        tableHeader.setColumnHeaders(ContractUtils.getColumnHeaderList());
        tableHeader.setColumnPath(AppPaths.REPORTS_CONTRACT_SEARCH);
        tableHeader.setColumnTextKey("common.column.");
        tableHeader.setRowCmd(rowCmd);
        tableHeader.setEmptyRowMsgKey("itMgmt.contractList.emptyTableMessage");
        if (rowCount != 0) {
            query.setLimit(rowLimit, rowStart);
            if (ContractUtils.isSortableColumn(orderBy)) {
                query.addSortColumn(ContractQueries.getOrderByColumn(orderBy), order);
            }
            List<DataRow> dataList = ContractUtils.fetchContractList(this.requestContext, query, new Counter(rowStart));
            tableHeader.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

