/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.hardware.HardwareSearchForm;
import com.kwoksys.action.reports.ReportForm;
import com.kwoksys.action.reports.ReportPreviewResultsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.core.HardwareSearch;
import com.kwoksys.biz.hardware.core.HardwareUtils;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.hardware.dto.Hardware;
import com.kwoksys.biz.reports.ReportService;
import com.kwoksys.biz.reports.ReportUtils;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReportPreviewHardwareResultsAction
extends Action2 {
    private HardwareSearchForm hardwareSearchForm;

    public String execute() throws Exception {
        ReportForm reportForm = this.getSessionBaseForm(ReportForm.class);
        this.hardwareSearchForm = this.getSessionBaseForm(HardwareSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(user, reportForm.getReportType())) {
            throw new AccessDeniedException();
        }
        if (reportForm.getReportType().equals("hardware_member_report")) {
            return this.hardwareMembers(this.request, this.response);
        }
        if (reportForm.getReportType().equals("hardware_license_report")) {
            return this.hardwareLicenses(this.request, this.response);
        }
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = this.requestContext.getParameterString("orderBy", "hardware_name");
        String order = this.requestContext.getParameterString("order");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getHardwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        hardwareSearch.prepareMap(this.hardwareSearchForm);
        HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
        QueryCriteria query = new QueryCriteria(hardwareSearch);
        query.setLimit(rowLimit, rowStart);
        if (HardwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(HardwareQueries.getOrderByColumn(orderBy), order);
        }
        int rowCount = hardwareService.getHardwareCount(query);
        List<DataRow> dataList = null;
        if (rowCount != 0) {
            List<Hardware> hardwareList = hardwareService.getHardwareList(query);
            dataList = HardwareUtils.formatHardwareList(this.requestContext, hardwareList, new Counter(rowStart), AppPaths.HARDWARE_DETAIL);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportForm.getReportType());
        for (String column : ConfigManager.app.getHardwareExportColumns()) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        for (Attribute attr : new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.HARDWARE).values()) {
            preview.addReportColumnOptions(new LabelValueBean(attr.getName(), String.valueOf(attr.getId())));
        }
        for (String column : HardwareUtils.getSortableColumns()) {
            preview.addSortColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "itMgmt.hardwareList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportForm.getReportType() + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportForm.getReportType() + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(HardwareUtils.getColumnHeaderList());
        tableTemplate.setColumnPath(AppPaths.HARDWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("itMgmt.hardwareList.emptyTableMessage");
        return standardTemplate.findTemplate("standard_template");
    }

    public String hardwareMembers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportType = this.requestContext.getParameterString("reportType");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = this.requestContext.getParameterString("orderBy", "hardware_name");
        String order = this.requestContext.getParameterString("order");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getHardwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        hardwareSearch.prepareMap(this.hardwareSearchForm);
        QueryCriteria searchQuery = new QueryCriteria(hardwareSearch);
        QueryCriteria query = new QueryCriteria();
        query.setLimit(rowLimit, rowStart);
        if (HardwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(ReportQueries.getHardwareMemberOrderByColumn(orderBy), order);
        }
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        int rowCount = reportService.getHardwareMembersCount(searchQuery);
        List<String> columnList = ReportUtils.getHardwareMembersExportColumns();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : new String[]{"hardware_id", "hardware_name"}) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "reports.list.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnList);
        tableTemplate.setColumnPath(AppPaths.HARDWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("itMgmt.hardwareList.emptyTableMessage");
        if (rowCount != 0) {
            Counter counter = new Counter(rowStart);
            List<Map<String, String>> hardwareList = reportService.getHardwareMembers(searchQuery, query);
            List<DataRow> dataList = this.formatDataList(this.requestContext, hardwareList, columnList, counter, AppPaths.HARDWARE_MEMBER);
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }

    public String hardwareLicenses(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String reportType = this.requestContext.getParameterString("reportType");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getHardwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        HardwareSearch hardwareSearch = new HardwareSearch(this.requestContext, "HARDWARE_REPORT_CRITERIA_MAP");
        hardwareSearch.prepareMap(this.hardwareSearchForm);
        QueryCriteria query = new QueryCriteria(hardwareSearch);
        query.setLimit(rowLimit, rowStart);
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("hardware_name"), "asc");
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("software_name"), "asc");
        query.addSortColumn(ReportQueries.getHardwareLicenseOrderByColumn("license_key"), "asc");
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        int rowCount = reportService.getHardwareLicenseCount(query);
        List<String> columnList = ReportUtils.getHardwareLicenseColumns();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : new String[]{"hardware_id", "hardware_name", "software_name", "license_key"}) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "reports.list.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_HARDWARE_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(columnList);
        tableTemplate.setColumnPath(AppPaths.HARDWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("itMgmt.hardwareList.emptyTableMessage");
        if (rowCount != 0) {
            List<Map<String, String>> hardwareList = reportService.getHardwareLicenses(query);
            List<DataRow> dataList = this.formatDataList(this.requestContext, hardwareList, columnList, new Counter(rowStart), AppPaths.HARDWARE_DETAIL);
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }

    private List<DataRow> formatDataList(RequestContext requestContext, List<Map<String, String>> dataset, List<String> columnList, Counter counter, String hardwarePath) throws Exception {
        ArrayList<DataRow> formattedDatalist = new ArrayList<DataRow>();
        if (dataset == null) {
            return formattedDatalist;
        }
        AccessUser user = requestContext.getUser();
        boolean hasHardwareAccess = Access.hasPermission(user, hardwarePath);
        for (Map<String, String> record : dataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : columnList) {
                String value;
                Link link;
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (column.equals("hardware_name")) {
                    link = new Link(requestContext);
                    link.setTitle(record.get("hardware_name"));
                    if (hasHardwareAccess) {
                        link.setAjaxPath(hardwarePath + "?hardwareId=" + record.get("hardware_id"));
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (column.equals("hardware_member_name")) {
                    link = new Link(requestContext);
                    link.setTitle(record.get("hardware_member_name"));
                    if (hasHardwareAccess) {
                        link.setAjaxPath(hardwarePath + "?hardwareId=" + record.get("hardware_member_id"));
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (column.equals("software_name")) {
                    value = record.get("software_name");
                    columns.add(value == null ? "" : HtmlUtils.encode(value));
                    continue;
                }
                if (!column.equals("license_key")) continue;
                value = record.get("license_key");
                columns.add(value == null ? "" : HtmlUtils.encode(value));
            }
            DataRow dataRow = new DataRow();
            dataRow.setColumns(columns);
            formattedDatalist.add(dataRow);
        }
        return formattedDatalist;
    }
}

