/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.issues.IssueSearchForm;
import com.kwoksys.action.reports.ReportPreviewResultsTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.IssueAccess;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.issues.IssueService;
import com.kwoksys.biz.issues.core.IssueSearch;
import com.kwoksys.biz.issues.core.IssueUtils;
import com.kwoksys.biz.issues.dao.IssueQueries;
import com.kwoksys.biz.issues.dto.Issue;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.List;

public class ReportPreviewIssueResultsAction
extends Action2 {
    public String execute() throws Exception {
        String reportType;
        IssueSearchForm actionForm = this.getSessionBaseForm(IssueSearchForm.class);
        AccessUser accessUser = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(accessUser, reportType = this.requestContext.getParameterString("reportType"))) {
            throw new AccessDeniedException();
        }
        String cmd = this.requestContext.getParameterString("cmd");
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getIssueRows());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        IssueSearch issueSearch = new IssueSearch(this.requestContext, "ISSUE_REPORT_CRITERIA_MAP");
        if (!cmd.isEmpty() && cmd.equals("search")) {
            issueSearch.reset();
            issueSearch.prepareMap(actionForm);
        }
        if (!accessUser.hasPermission(1)) {
            issueSearch.put("issuePermittedUserId", accessUser.getId());
        }
        IssueService issueService = ServiceProvider.getIssueService(this.requestContext);
        QueryCriteria query = new QueryCriteria(issueSearch);
        query.setLimit(rowLimit, rowStart);
        query.addSortColumn(IssueQueries.getOrderByColumn("creation_date"), "desc");
        int rowCount = issueService.getCount(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : ConfigManager.app.getIssueExportColumns()) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        for (Attribute attr : new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.ISSUE).values()) {
            preview.addReportColumnOptions(new LabelValueBean(attr.getName(), String.valueOf(attr.getId())));
        }
        for (String column : IssueUtils.getSortableColumns()) {
            preview.addSortColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "issueMgmt.issueList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_ISSUE_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_ISSUE_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(IssueUtils.getIssueColumnHeaders());
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("issueMgmt.issueList.emptyTableMessage");
        if (rowCount != 0) {
            List<Issue> issues = issueService.getIssues(query);
            boolean hasIssueDetailAccess = Access.hasPermission(accessUser, AppPaths.ISSUES_DETAIL);
            IssueAccess access = new IssueAccess(accessUser);
            if (hasIssueDetailAccess) {
                access.setAllowedIssues(issues);
            }
            List<DataRow> dataList = IssueUtils.formatIssues(this.requestContext, issues, access, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

