/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.reports.ReportPreviewResultsTemplate;
import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.admin.dto.Attribute;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.AttributeManager;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import java.util.List;

public class ReportPreviewSoftwareResultsAction
extends Action2 {
    public String execute() throws Exception {
        String reportType;
        SoftwareSearchForm actionForm = this.getSessionBaseForm(SoftwareSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(user, reportType = this.requestContext.getParameterString("reportType"))) {
            throw new AccessDeniedException();
        }
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String orderBy = this.requestContext.getParameterString("orderBy", "software_name");
        String order = this.requestContext.getParameterString("order");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getSoftwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        SoftwareSearch softwareSearch = new SoftwareSearch(this.requestContext, "SOFTWARE_REPORT_CRITERIA_MAP");
        softwareSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(softwareSearch);
        query.setLimit(rowLimit, rowStart);
        if (SoftwareUtils.isSortableColumn(orderBy)) {
            query.addSortColumn(SoftwareQueries.getOrderByColumn(orderBy), order);
        }
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        int rowCount = softwareService.getSoftwareCount(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : ConfigManager.app.getSoftwareExportColumns()) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        for (Attribute attr : new AttributeManager(this.requestContext).getCustomFieldMap(ObjectTypes.SOFTWARE).values()) {
            preview.addReportColumnOptions(new LabelValueBean(attr.getName(), String.valueOf(attr.getId())));
        }
        for (String column : SoftwareUtils.getSortableColumns()) {
            preview.addSortColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "itMgmt.softwareList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_SOFTWARE_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_SOFTWARE_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(SoftwareUtils.getColumnHeaderList());
        tableTemplate.setColumnPath(AppPaths.SOFTWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("itMgmt.softwareList.emptyTableMessage");
        if (rowCount != 0) {
            List<Software> softwareList = softwareService.getSoftwareList(query);
            List<DataRow> dataList = SoftwareUtils.formatSoftwareList(this.requestContext, softwareList, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

