/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.RecordsNavigationTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.reports.ReportPreviewResultsTemplate;
import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.reports.ReportService;
import com.kwoksys.biz.reports.ReportUtils;
import com.kwoksys.biz.reports.dao.ReportQueries;
import com.kwoksys.biz.reports.dto.SoftwareUsage;
import com.kwoksys.biz.software.SoftwareSearch;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.http.RequestContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;
import java.util.List;

public class ReportPreviewSoftwareUsageResultsAction
extends Action2 {
    public String execute() throws Exception {
        String reportType;
        SoftwareSearchForm actionForm = this.getSessionBaseForm(SoftwareSearchForm.class);
        AccessUser user = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(user, reportType = this.requestContext.getParameterString("reportType"))) {
            throw new AccessDeniedException();
        }
        String rowCmd = this.requestContext.getParameterString("rowCmd");
        String order = this.requestContext.getParameterString("order");
        int rowStart = this.requestContext.getParameter("rowStart", 0);
        int rowLimit = this.requestContext.getParameter("rowLimit", ConfigManager.app.getSoftwareRowsToShow());
        if (rowCmd.equals("showAll")) {
            rowLimit = 0;
        }
        SoftwareSearch softwareSearch = new SoftwareSearch(this.requestContext, "SOFTWARE_USAGE_REPORT_CRITERIA_MAP");
        softwareSearch.prepareMap(actionForm);
        QueryCriteria query = new QueryCriteria(softwareSearch);
        query.setLimit(rowLimit, rowStart);
        query.addSortColumn(ReportQueries.getSoftwareUsageOrderByColumn("software_name"), order);
        query.addSortColumn(ReportQueries.getSoftwareUsageOrderByColumn("hardware_name"), order);
        ReportService reportService = ServiceProvider.getReportService(this.requestContext);
        int rowCount = reportService.getSoftwareUsageCount(query);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        ReportPreviewResultsTemplate preview = standardTemplate.addTemplate(new ReportPreviewResultsTemplate());
        preview.setReportType(reportType);
        for (String column : ReportUtils.getSoftwareUsageExportColumns()) {
            preview.addReportColumnOptions(new LabelValueBean(Localizer.getText(this.requestContext, "common.column." + column), column));
        }
        RecordsNavigationTemplate nav = standardTemplate.addTemplate(new RecordsNavigationTemplate());
        nav.setRowOffset(rowStart);
        nav.setRowLimit(rowLimit);
        nav.setRowCount(rowCount);
        nav.setRowCountMsgkey("core.template.recordsNav.rownum");
        nav.setShowAllRecordsText(Localizer.getText(this.requestContext, "itMgmt.softwareList.rowCount", new Object[]{rowCount}));
        nav.setShowAllRecordsPath(AppPaths.REPORTS_SOFTWARE_USAGE_SEARCH + "?reportType=" + reportType + "&rowCmd=showAll");
        nav.setPath(AppPaths.REPORTS_SOFTWARE_USAGE_SEARCH + "?reportType=" + reportType + "&rowStart=");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setColumnHeaders(ReportUtils.getSoftwareUsageColumns());
        tableTemplate.setColumnPath(AppPaths.SOFTWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setRowCmd(rowCmd);
        tableTemplate.setEmptyRowMsgKey("itMgmt.softwareList.emptyTableMessage");
        if (rowCount != 0) {
            List<SoftwareUsage> softwareList = reportService.getSoftwareUsage(query);
            List<DataRow> dataList = ReportPreviewSoftwareUsageResultsAction.formatDataList(this.requestContext, softwareList, new Counter(rowStart));
            tableTemplate.setDataList(dataList);
        }
        return standardTemplate.findTemplate("standard_template");
    }

    private static List<DataRow> formatDataList(RequestContext requestContext, List<SoftwareUsage> softwareDataset, Counter counter) throws Exception {
        ArrayList<DataRow> softwareList = new ArrayList<DataRow>();
        if (softwareDataset == null) {
            return softwareList;
        }
        AccessUser user = requestContext.getUser();
        boolean hasSoftwareAccess = Access.hasPermission(user, AppPaths.SOFTWARE_DETAIL);
        boolean hasHardwareAccess = Access.hasPermission(user, AppPaths.HARDWARE_DETAIL);
        boolean hasUserAccess = Access.hasPermission(user, AppPaths.ADMIN_USER_DETAIL);
        for (SoftwareUsage software : softwareDataset) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : ReportUtils.getSoftwareUsageColumns()) {
                Link link;
                if (column.equals("rownum")) {
                    columns.add(counter.incr() + ".");
                    continue;
                }
                if (column.equals("software_name")) {
                    link = new Link(requestContext);
                    link.setTitle(software.getName());
                    if (hasSoftwareAccess) {
                        link.setAjaxPath(AppPaths.SOFTWARE_DETAIL + "?softwareId=" + software.getId());
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (column.equals("software_type")) {
                    columns.add(HtmlUtils.encode(software.getTypeName()));
                    continue;
                }
                if (column.equals("hardware_name")) {
                    link = new Link(requestContext);
                    link.setTitle(software.getHardwareName());
                    if (hasHardwareAccess) {
                        link.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + software.getHardwareId());
                    }
                    columns.add(link.getString());
                    continue;
                }
                if (!column.equals("hardware_owner_name")) continue;
                link = new Link(requestContext);
                link.setTitle(software.getHardwareOwnerName());
                if (hasUserAccess) {
                    link.setAjaxPath(AppPaths.ADMIN_USER_DETAIL + "?userId=" + software.getHardwareOwnerId());
                }
                columns.add(link.getString());
            }
            DataRow dataRow = new DataRow();
            dataRow.setColumns(columns);
            softwareList.add(dataRow);
        }
        return softwareList;
    }
}

