/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.HeaderSimpleTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.reports.ReportForm;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.ReportFactory;
import com.kwoksys.biz.reports.writers.CsvReportWriter;
import com.kwoksys.biz.reports.writers.HtmlReportWriter;
import com.kwoksys.biz.reports.writers.PdfReportWriter;
import com.kwoksys.biz.reports.writers.ReportWriter;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.http.ResponseContext;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;

public class ReportResultsExportAction
extends Action2 {
    public String execute() throws Exception {
        ReportForm reportForm;
        ResponseContext responseContext = new ResponseContext(this.response);
        AccessUser user = this.requestContext.getUser();
        if (!ReportAccess.hasPermission(user, (reportForm = this.getSessionBaseForm(ReportForm.class)).getReportType())) {
            throw new AccessDeniedException();
        }
        Report report = ReportFactory.getReport(this.requestContext, reportForm);
        report.setTitle(reportForm.getReportTitle());
        report.setReportColumns(reportForm.getReportColumns());
        report.setReportColumnOrder(reportForm.getReportSortOrder());
        report.setReportColumnOrderBy(reportForm.getReportSortColumns());
        if (reportForm.getOutputType().equals("pdf_list")) {
            PdfReportWriter reportWriter = new PdfReportWriter();
            responseContext.setAttachementName(report.getPdfFilename());
            ((ReportWriter)reportWriter).init(responseContext, report);
            report.populateData(reportWriter);
            return ((ReportWriter)reportWriter).close();
        }
        if (reportForm.getOutputType().equals("csv_table")) {
            CsvReportWriter reportWriter = new CsvReportWriter();
            responseContext.setAttachementName(report.getCsvFilename());
            ((ReportWriter)reportWriter).init(responseContext, report);
            report.populateData(reportWriter);
            return ((ReportWriter)reportWriter).close();
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderSimpleTemplate headerSimpleTemplate = standardTemplate.addTemplate(new HeaderSimpleTemplate());
        headerSimpleTemplate.setTitleText(Localizer.getText(this.requestContext, "reports.workflow.type." + reportForm.getReportType()));
        HtmlReportWriter reportWriter = new HtmlReportWriter();
        report.populateData(reportWriter);
        this.request.setAttribute("columnHeaders", reportWriter.getColumnHeaders());
        this.request.setAttribute("rows", reportWriter.getRows());
        this.request.setAttribute("reportTitle", (Object)report.getTitle());
        return standardTemplate.findTemplate(reportForm.getOutputType());
    }
}

