/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.reports;

import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.contracts.ContractSearchForm;
import com.kwoksys.action.contracts.ContractSearchTemplate;
import com.kwoksys.action.hardware.HardwareSearchForm;
import com.kwoksys.action.hardware.HardwareSearchTemplate;
import com.kwoksys.action.issues.IssueSearchForm;
import com.kwoksys.action.issues.IssueSearchTemplate;
import com.kwoksys.action.reports.ReportForm;
import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.action.software.SoftwareSearchTemplate;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.ReportAccess;
import com.kwoksys.biz.base.BaseTemplate;
import com.kwoksys.biz.reports.Report;
import com.kwoksys.biz.reports.ReportFactory;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.exceptions.AccessDeniedException;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;

public class ReportSearchCriteriaAction
extends Action2 {
    public String execute() throws Exception {
        BaseTemplate searchTemplate;
        ReportForm reportForm = this.getSessionBaseForm(ReportForm.class);
        AccessUser user = this.requestContext.getUser();
        String reportType = reportForm.getReportType();
        String cmd = this.requestContext.getParameterString("cmd");
        if (cmd.equals("clear")) {
            SessionManager.clearReportFromSession(this.requestContext, reportType);
        }
        if (!ReportAccess.hasPermission(user, reportType)) {
            throw new AccessDeniedException();
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        if (reportType.equals("issue_report")) {
            this.getSessionBaseForm(IssueSearchForm.class);
            searchTemplate = standardTemplate.addTemplate(new IssueSearchTemplate());
            ((IssueSearchTemplate)searchTemplate).setFormAction(AppPaths.REPORTS_ISSUE_SEARCH);
            ((IssueSearchTemplate)searchTemplate).setHideSearchButton(true);
        } else if (reportType.equals("hardware_report") || reportType.equals("hardware_member_report") || reportType.equals("hardware_license_report")) {
            this.getSessionBaseForm(HardwareSearchForm.class);
            searchTemplate = standardTemplate.addTemplate(new HardwareSearchTemplate());
            ((HardwareSearchTemplate)searchTemplate).setFormAction(AppPaths.REPORTS_HARDWARE_SEARCH);
            ((HardwareSearchTemplate)searchTemplate).setHideSearchButton(true);
        } else if (reportType.equals("software_report")) {
            this.getSessionBaseForm(SoftwareSearchForm.class);
            searchTemplate = standardTemplate.addTemplate(new SoftwareSearchTemplate());
            ((SoftwareSearchTemplate)searchTemplate).setFormAction(AppPaths.REPORTS_SOFTWARE_SEARCH);
            ((SoftwareSearchTemplate)searchTemplate).setHideSearchButton(true);
        } else if (reportType.equals("software_usage_report")) {
            this.getSessionBaseForm(SoftwareSearchForm.class);
            searchTemplate = standardTemplate.addTemplate(new SoftwareSearchTemplate());
            ((SoftwareSearchTemplate)searchTemplate).setFormAction(AppPaths.REPORTS_SOFTWARE_USAGE_SEARCH);
            ((SoftwareSearchTemplate)searchTemplate).setHideSearchButton(true);
        } else if (reportType.equals("contract_report")) {
            this.getSessionBaseForm(ContractSearchForm.class);
            searchTemplate = standardTemplate.addTemplate(new ContractSearchTemplate());
            ((ContractSearchTemplate)searchTemplate).setFormAction(AppPaths.REPORTS_CONTRACT_SEARCH);
            ((ContractSearchTemplate)searchTemplate).setHideSearchButton(true);
        }
        Report report = ReportFactory.getReport(this.requestContext, reportType);
        standardTemplate.setAttribute("formName", report.getReportFormName());
        standardTemplate.setAttribute("reportType", reportType);
        standardTemplate.setPathAttribute("reportBackAction", AppPaths.REPORTS_TYPE_SELECT);
        return standardTemplate.findTemplate("standard_template");
    }
}

