/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.rss;

import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.portal.PortalUtils;
import com.kwoksys.biz.rss.RssService;
import com.kwoksys.biz.rss.dto.RssFeed;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.parsers.rss.RssModel;
import com.kwoksys.framework.parsers.rss.RssModelHelper;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RssFeedListItemsAction
extends Action2 {
    private static final Logger LOGGER = Logger.getLogger(RssFeedListItemsAction.class.getName());

    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        Integer feedId = this.requestContext.getParameter("feedId");
        RssService rssService = ServiceProvider.getRssService(this.requestContext);
        RssFeed rssFeed = rssService.getRssFeed(feedId);
        long systemUnixtime = this.requestContext.getSysdate().getTime();
        long rssUnixtime = rssFeed.getCacheDate().getTime();
        try {
            RssModelHelper helper = new RssModelHelper();
            if (systemUnixtime > rssUnixtime + (long)ConfigManager.app.getRssCacheTimeInMinutes() || rssFeed.getCache().isEmpty()) {
                helper.urlToModel(rssFeed.getUrl());
                rssFeed.setModel(helper.getRssModel());
                rssFeed.setItemCount(helper.getRssModel().getCount());
                rssFeed.setCache(helper.getXmlString());
                rssService.updateRssFeedContent(rssFeed);
            } else {
                helper.xmlToModel(rssFeed.getCache());
                rssFeed.setModel(helper.getRssModel());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Problem retrieving RSS feed.", e);
            RssModel rssModel = new RssModel();
            rssModel.setLink(rssFeed.getUrl());
            rssModel.setTitle("Problem retrieving RSS feed...");
            rssFeed.setModel(rssModel);
        }
        ArrayList items = new ArrayList();
        for (RssModel.Item item : rssFeed.getModel().getItems()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("description", PortalUtils.formatRssItem(item.getDescription()));
            map.put("link", new Link(this.requestContext).setExternalPath(item.getLink()).setStyleClass("rssTitle").setTitle(item.getTitle()).getString());
            items.add(map);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("rssFeed", rssFeed);
        standardTemplate.setAttribute("rssFeedItems", items);
        if (Access.hasPermission(user, AppPaths.RSS_FEED_EDIT)) {
            standardTemplate.setAttribute("editRssFeedLink", new Link(this.requestContext).setAppPath(AppPaths.RSS_FEED_EDIT + "?feedId=" + rssFeed.getId()).setTitleKey("common.action.Edit").setTarget("_parent").getString());
        }
        if (Access.hasPermission(user, AppPaths.RSS_FEED_DELETE)) {
            standardTemplate.setAttribute("deleteRssFeedLink", new Link(this.requestContext).setAppPath(AppPaths.RSS_FEED_DELETE + "?feedId=" + rssFeed.getId()).setTitleKey("common.action.Delete").setTarget("_parent").getString());
        }
        String sessionTheme = SessionManager.getAppSessionTheme(this.request.getSession());
        standardTemplate.setAttribute("themeStylePath", AppPaths.getInstance().getThemeCss(sessionTheme));
        standardTemplate.setAttribute("rssFeedSourceLink", new Link(this.requestContext).setExternalPath(rssFeed.getModel().getLink()).setTitle(rssFeed.getModel().getTitle()));
        return standardTemplate.findTemplate("success");
    }
}

