/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.rss;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.rss.RssService;
import com.kwoksys.biz.rss.dto.RssFeed;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.session.SessionManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;

public class RssFeedListTitlesAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn("feed_name");
        ArrayList<String> rssFeeds = new ArrayList<String>();
        RssService rssService = ServiceProvider.getRssService(this.requestContext);
        for (RssFeed rssFeed : rssService.getRssFeeds(query)) {
            Link link = new Link(this.requestContext);
            link.setJavascript("parent.frameItems.location.href='" + AppPaths.ROOT + AppPaths.RSS_FEED_LIST_ITEMS + "?feedId=" + rssFeed.getId() + "'");
            link.setTitle(rssFeed.getName() + " (" + rssFeed.getItemCount() + ")");
            rssFeeds.add(link.getString());
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("rssFeeds", rssFeeds);
        String sessionTheme = SessionManager.getAppSessionTheme(this.request.getSession());
        standardTemplate.setAttribute("themeStylePath", AppPaths.getInstance().getThemeCss(sessionTheme));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (Access.hasPermission(user, AppPaths.RSS_FEED_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.RSS_FEED_ADD);
            link.setTitleKey("portal.rssFeedAdd.title");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("success");
    }
}

