/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.AjaxTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.hardware.HardwareService;
import com.kwoksys.biz.hardware.dao.HardwareQueries;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.LabelValueBean;
import com.kwoksys.framework.util.HtmlUtils;
import java.util.ArrayList;

public class GetLicenseBySoftwareAjax
extends Action2 {
    public String execute() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        ArrayList<LabelValueBean> licenseOptions = new ArrayList<LabelValueBean>();
        if (softwareId != 0) {
            QueryCriteria query = new QueryCriteria();
            query.addSortColumn(HardwareQueries.getOrderByColumn("license_key"));
            HardwareService hardwareService = ServiceProvider.getHardwareService(this.requestContext);
            for (SoftwareLicense license : hardwareService.getAvailableLicenses(query, softwareId)) {
                licenseOptions.add(new LabelValueBean(HtmlUtils.encode(license.getKey()) + (license.getNote().isEmpty() ? "" : " (" + SoftwareUtils.formatLicenseKey(license.getNote()) + ")"), String.valueOf(license.getId())));
            }
        }
        AjaxTemplate ajaxTemplate = new AjaxTemplate(this.requestContext);
        ajaxTemplate.setAttribute("licenseOptions", licenseOptions);
        return ajaxTemplate.findTemplate("ajax_template");
    }
}

