/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.software.SoftwareSearchForm;
import com.kwoksys.action.software.SoftwareSearchTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;

public class IndexAction
extends Action2 {
    public String execute() throws Exception {
        AccessUser user = this.requestContext.getUser();
        HttpSession session = this.request.getSession();
        if (this.requestContext.getParameterString("cmd").equals("clear")) {
            session.setAttribute("SOFTWARE_SEARCH_CRITERIA_MAP", null);
            this.clearSessionBaseForm(SoftwareSearchForm.class);
        }
        this.getSessionBaseForm(SoftwareSearchForm.class);
        ArrayList<Link> links = new ArrayList<Link>();
        if (user.hasPermission(AppPaths.SOFTWARE_LIST)) {
            if (session.getAttribute("SOFTWARE_SEARCH_CRITERIA_MAP") != null) {
                links.add(new Link(this.requestContext).setTitleKey("common.search.showLastSearch").setAjaxPath(AppPaths.SOFTWARE_LIST));
            }
            links.add(new Link(this.requestContext).setAjaxPath(AppPaths.SOFTWARE_LIST + "?cmd=showAll").setTitleKey("itMgmt.index.showAllSoftware"));
        }
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        int numSoftwareRecords = softwareService.getSoftwareCount(new QueryCriteria());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("linkList", links);
        standardTemplate.setPathAttribute("lookupAction", AppPaths.SOFTWARE_DETAIL + "?softwareId=");
        SoftwareSearchTemplate searchTemplate = standardTemplate.addTemplate(new SoftwareSearchTemplate());
        searchTemplate.setFormAction(AppPaths.SOFTWARE_LIST);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setTitleKey("core.moduleName.2");
        header.setTitleClassNoLine();
        header.setSectionKey("itMgmt.softwareIndex.numRecords", new Object[]{numSoftwareRecords});
        if (user.hasPermission(AppPaths.SOFTWARE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_ADD);
            link.setTitleKey("itMgmt.cmd.softwareAdd");
            header.addHeaderCmds(link);
        }
        return standardTemplate.findTemplate("standard_template");
    }
}

