/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.software.SoftwareBookmarkForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.software.dto.SoftwareBookmark;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.dao.BookmarkQueries;
import com.kwoksys.biz.system.dto.Bookmark;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SoftwareBookmarkAction
extends Action2 {
    public String list() throws Exception {
        boolean canEditBookmark;
        String editBookmarkPath;
        SoftwareBookmarkForm actionForm = this.getBaseForm(SoftwareBookmarkForm.class);
        AccessUser accessUser = this.requestContext.getUser();
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        String editBookmarkText = Localizer.getText(this.requestContext, "common.action.Edit");
        int bookmarkRowSpan = 2;
        boolean canDeleteBookmark = Access.hasPermission(accessUser, AppPaths.SOFTWARE_BOOKMARK_DELETE_2);
        if (canDeleteBookmark) {
            ++bookmarkRowSpan;
        }
        String string = editBookmarkPath = (canEditBookmark = Access.hasPermission(accessUser, AppPaths.SOFTWARE_BOOKMARK_EDIT)) ? AppPaths.SOFTWARE_BOOKMARK_EDIT : "";
        if (canEditBookmark) {
            ++bookmarkRowSpan;
        }
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(BookmarkQueries.getOrderByColumn("bookmark_name"));
        List<Bookmark> bookmarks = softwareService.getSoftwareBookmarks(query, software.getId());
        ArrayList bookmarkList = new ArrayList();
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("bookmarks", bookmarkList);
        standardTemplate.setAttribute("canDeleteBookmark", canDeleteBookmark);
        standardTemplate.setPathAttribute("deleteBookmarkPath", AppPaths.SOFTWARE_BOOKMARK_DELETE_2);
        standardTemplate.setAttribute("canEditBookmark", canEditBookmark);
        standardTemplate.setAttribute("bookmarkRowSpan", bookmarkRowSpan);
        if (!bookmarks.isEmpty()) {
            for (Bookmark bookmark : bookmarks) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bookmarkPath", new Link(this.requestContext).setExternalPath(bookmark.getPath()).setTitle(bookmark.getName()).setInlineImage(Image.getInstance().getExternalPopupIcon(this.requestContext)).setImgAlignRight().getString());
                if (canEditBookmark) {
                    map.put("bookmarkEditPath", new Link(this.requestContext).setAjaxPath(editBookmarkPath + "?softwareId=" + software.getId() + "&bookmarkId=" + bookmark.getId()).setEscapeTitle(editBookmarkText).getString());
                }
                map.put("bookmarkId", String.valueOf(bookmark.getId()));
                bookmarkList.add(map);
            }
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(bookmarkRowSpan);
            empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.softwareBookmark.emptyTableMessage"));
        }
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        SoftwareUtils.addSoftwareHeaderCommands(this.requestContext, header, software.getId());
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        if (Access.hasPermission(accessUser, AppPaths.SOFTWARE_BOOKMARK_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_BOOKMARK_ADD + "?softwareId=" + software.getId());
            link.setTitleKey("bookmarkMgmt.bookmarkAdd");
            header.addHeaderCmds(link);
        }
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(SoftwareUtils.getSoftwareTabs(this.requestContext, software));
        tabs.setTabActive("bookmarksTab");
        return standardTemplate.findTemplate("standard_template");
    }

    public String add() throws Exception {
        SoftwareBookmarkForm actionForm = this.getBaseForm(SoftwareBookmarkForm.class);
        actionForm.setId("softwareBookmarkAddForm");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        Bookmark bookmark = new Bookmark();
        if (!actionForm.isResubmit()) {
            actionForm.setBookmark(bookmark);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_BOOKMARK_ADD_2);
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + software.getId()).getString());
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new String[]{software.getName()});
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String add2() throws Exception {
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        SoftwareBookmarkForm actionForm = this.saveActionForm(new SoftwareBookmarkForm());
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        SoftwareBookmark bookmark = new SoftwareBookmark(software.getId());
        bookmark.setName(actionForm.getBookmarkName());
        bookmark.setPath(actionForm.getBookmarkPath());
        bookmark.setDescription("");
        ActionMessages errors = softwareService.addSoftwareBookmark(bookmark);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_BOOKMARK_ADD + "?softwareId=" + software.getId() + "&" + "_error=true");
        }
        softwareService.resetSoftwareBookmarkCount(software.getId());
        return this.ajaxUpdateView(AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + software.getId());
    }

    public String delete2() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.getSoftware(softwareId);
        Integer bookmarkId = this.requestContext.getParameter("bookmarkId");
        Bookmark bookmark = softwareService.getSoftwareBookmark(softwareId, bookmarkId);
        softwareService.deleteSoftwareBookmark(bookmark);
        softwareService.resetSoftwareBookmarkCount(softwareId);
        return this.ajaxUpdateView(AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + softwareId);
    }

    public String edit() throws Exception {
        SoftwareBookmarkForm actionForm = this.getBaseForm(SoftwareBookmarkForm.class);
        actionForm.setId("softwareBookmarkEditForm");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(actionForm.getSoftwareId());
        Bookmark bookmark = softwareService.getSoftwareBookmark(software.getId(), actionForm.getBookmarkId());
        if (!actionForm.isResubmit()) {
            actionForm.setBookmark(bookmark);
        }
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setPathAttribute("formAction", AppPaths.SOFTWARE_BOOKMARK_EDIT_2 + "?softwareId=" + software.getId() + "&bookmarkId=" + bookmark.getId());
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + software.getId()).getString());
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
        errorsTemplate.setShowRequiredFieldMsg(true);
        return standardTemplate.findTemplate("standard_template");
    }

    public String edit2() throws Exception {
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        SoftwareBookmarkForm actionForm = this.saveActionForm(new SoftwareBookmarkForm());
        Bookmark bookmark = softwareService.getSoftwareBookmark(actionForm.getSoftwareId(), actionForm.getBookmarkId());
        bookmark.setName(actionForm.getBookmarkName());
        bookmark.setPath(actionForm.getBookmarkPath());
        bookmark.setDescription("");
        ActionMessages errors = softwareService.updateSoftwareBookmark(bookmark);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_BOOKMARK_EDIT + "?softwareId=" + bookmark.getObjectId() + "&bookmarkId=" + bookmark.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_BOOKMARK + "?softwareId=" + bookmark.getObjectId());
    }
}

