/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.contacts.ContactAssociateTemplate;
import com.kwoksys.action.software.SoftwareContactForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.auth.core.Access;
import com.kwoksys.biz.contacts.core.ContactUtils;
import com.kwoksys.biz.contacts.dao.ContactQueries;
import com.kwoksys.biz.contacts.dto.Contact;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.dto.linking.SoftwareContactLink;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.data.DataRow;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.struts2.ActionMessages;
import com.kwoksys.framework.ui.Link;
import java.util.Arrays;
import java.util.List;

public class SoftwareContactsAction
extends Action2 {
    public String list() throws Exception {
        Integer softwareId = this.requestContext.getParameterInteger("softwareId");
        AccessUser accessUser = this.requestContext.getUser();
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        this.getBaseForm(SoftwareContactForm.class);
        Software software = softwareService.getSoftware(softwareId);
        List<String> columnHeaders = Arrays.asList("contact_first_name", "contact_last_name", "contact_email_primary", "relationship_description");
        String orderBy = "contact_first_name";
        String order = "asc";
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.addSortColumn(ContactQueries.getOrderByColumn(orderBy));
        List<Contact> contacts = softwareService.getSoftwareContacts(queryCriteria, software.getId());
        List<DataRow> dataList = ContactUtils.formatContacts(this.requestContext, contacts, columnHeaders, new Counter());
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        SoftwareUtils.addSoftwareHeaderCommands(this.requestContext, header, software.getId());
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        if (Access.hasPermission(accessUser, AppPaths.SOFTWARE_CONTACT_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(AppPaths.SOFTWARE_CONTACT_ADD + "?softwareId=" + software.getId());
            link.setTitleKey("common.linking.linkContacts");
            header.addHeaderCmds(link);
        }
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        standardTemplate.addTemplate(new ActionErrorsTemplate());
        TabsTemplate tabsTemplate = standardTemplate.addTemplate(new TabsTemplate());
        tabsTemplate.setTabList(SoftwareUtils.getSoftwareTabs(this.requestContext, software));
        tabsTemplate.setTabActive("contactsTab");
        TableTemplate tableTemplate = standardTemplate.addTemplate(new TableTemplate());
        tableTemplate.setDataList(dataList);
        tableTemplate.setColumnHeaders(columnHeaders);
        tableTemplate.setColumnPath(AppPaths.SOFTWARE_LIST);
        tableTemplate.setColumnTextKey("common.column.");
        tableTemplate.setOrderBy(orderBy);
        tableTemplate.setOrder(order);
        tableTemplate.setFormRemoveItemAction(AppPaths.SOFTWARE_CONTACT_REMOVE_2);
        tableTemplate.getFormHiddenVariableMap().put("softwareId", String.valueOf(software.getId()));
        tableTemplate.setFormRowIdName("contactId");
        tableTemplate.setEmptyRowMsgKey("contactMgmt.contactList.emptyTableMessage");
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add() throws Exception {
        Integer softwareId = this.requestContext.getParameterInteger("softwareId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        SoftwareContactForm actionForm = this.getBaseForm(SoftwareContactForm.class);
        actionForm.setContactId(this.requestContext.getParameterInteger("formContactId"));
        Software software = softwareService.getSoftware(softwareId);
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        standardTemplate.setAttribute("softwareId", software.getId());
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        ContactAssociateTemplate associateTemplate = standardTemplate.addTemplate(new ContactAssociateTemplate());
        associateTemplate.setFormContactId(actionForm.getFormContactId());
        associateTemplate.setFormSearchAction(AppPaths.SOFTWARE_CONTACT_ADD + "?softwareId=" + software.getId());
        associateTemplate.setFormSaveAction(AppPaths.SOFTWARE_CONTACT_ADD_2 + "?softwareId=" + software.getId());
        associateTemplate.setFormCancelAction(AppPaths.SOFTWARE_CONTACTS + "?softwareId=" + software.getId());
        return standardTemplate.findTemplate("standard_autogen_template");
    }

    public String add2() throws Exception {
        SoftwareContactForm contactForm = this.saveActionForm(new SoftwareContactForm());
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(contactForm.getSoftwareId());
        SoftwareContactLink softwareContactLink = new SoftwareContactLink();
        softwareContactLink.setSoftwareId(software.getId());
        softwareContactLink.setContactId(contactForm.getContactId());
        softwareContactLink.setRelDescription(contactForm.getRelationshipDescription());
        ActionMessages errors = softwareService.addSoftwareContact(softwareContactLink);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_CONTACT_ADD + "?softwareId=" + software.getId() + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_CONTACTS + "?softwareId=" + software.getId());
    }

    public String remove2() throws Exception {
        Integer softwareId = this.requestContext.getParameter("softwareId");
        Integer contactId = this.requestContext.getParameter("contactId");
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        softwareService.getSoftware(softwareId);
        SoftwareContactLink softwareContactLink = new SoftwareContactLink();
        softwareContactLink.setSoftwareId(softwareId);
        softwareContactLink.setContactId(contactId);
        ActionMessages errors = softwareService.deleteSoftwareContact(softwareContactLink);
        if (!errors.isEmpty()) {
            this.saveActionErrors(errors);
            return this.ajaxUpdateView(AppPaths.SOFTWARE_CONTACTS + "?softwareId=" + softwareId + "&" + "_error=true");
        }
        return this.ajaxUpdateView(AppPaths.SOFTWARE_CONTACTS + "?softwareId=" + softwareId);
    }
}

