/*
 * Decompiled with CFR 0.152.
 */
package com.kwoksys.action.software;

import com.kwoksys.action.common.template.ActionErrorsTemplate;
import com.kwoksys.action.common.template.CustomFieldsTemplate;
import com.kwoksys.action.common.template.HeaderTemplate;
import com.kwoksys.action.common.template.StandardTemplate;
import com.kwoksys.action.common.template.TableEmptyTemplate;
import com.kwoksys.action.common.template.TabsTemplate;
import com.kwoksys.action.software.SoftwareLicenseForm;
import com.kwoksys.action.software.SoftwareSpecTemplate;
import com.kwoksys.biz.ServiceProvider;
import com.kwoksys.biz.admin.AdminService;
import com.kwoksys.biz.admin.core.AdminUtils;
import com.kwoksys.biz.admin.dto.AccessUser;
import com.kwoksys.biz.software.SoftwareService;
import com.kwoksys.biz.software.SoftwareUtils;
import com.kwoksys.biz.software.dao.SoftwareQueries;
import com.kwoksys.biz.software.dto.Software;
import com.kwoksys.biz.software.dto.SoftwareLicense;
import com.kwoksys.biz.system.core.AppPaths;
import com.kwoksys.biz.system.core.Image;
import com.kwoksys.biz.system.core.Links;
import com.kwoksys.biz.system.core.ObjectTypes;
import com.kwoksys.biz.system.core.configs.ConfigManager;
import com.kwoksys.framework.connections.database.QueryCriteria;
import com.kwoksys.framework.data.Counter;
import com.kwoksys.framework.properties.Localizer;
import com.kwoksys.framework.session.CacheManager;
import com.kwoksys.framework.struts2.Action2;
import com.kwoksys.framework.ui.Link;
import com.kwoksys.framework.util.HtmlUtils;
import com.kwoksys.framework.util.NumberUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SoftwareDetailAction
extends Action2 {
    public String execute() throws Exception {
        Link hardwareDetailsLink;
        AccessUser accessUser = this.requestContext.getUser();
        SoftwareLicenseForm actionForm = this.getBaseForm(SoftwareLicenseForm.class);
        Integer softwareId = actionForm.getSoftwareId();
        SoftwareService softwareService = ServiceProvider.getSoftwareService(this.requestContext);
        Software software = softwareService.getSoftware(softwareId);
        String cmd = actionForm.getCmd();
        String formAction = AppPaths.SOFTWARE_LICENSE_DELETE_2;
        Integer formLicenseId = 0;
        boolean canEditLicense = accessUser.hasPermission(AppPaths.SOFTWARE_LICENSE_EDIT_2);
        boolean canDeleteLicense = accessUser.hasPermission(AppPaths.SOFTWARE_LICENSE_DELETE_2);
        boolean hasHardwareAccess = accessUser.hasPermission(AppPaths.HARDWARE_DETAIL);
        boolean hasHardwareAjaxAccess = accessUser.hasPermission(AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL);
        AdminService adminService = ServiceProvider.getAdminService(this.requestContext);
        boolean hasLicenseCustomFields = adminService.hasCustomFields(ObjectTypes.SOFTWARE_LICENSE);
        String editLicensePath = (hasLicenseCustomFields ? AppPaths.SOFTWARE_LICENSE_EDIT : AppPaths.SOFTWARE_DETAIL) + "?softwareId=" + softwareId;
        boolean showAddLicenseForm = false;
        StandardTemplate standardTemplate = new StandardTemplate(this.requestContext);
        HeaderTemplate header = standardTemplate.getHeaderTemplate();
        if (!cmd.isEmpty() && !hasLicenseCustomFields) {
            if (cmd.equals("add") && accessUser.hasPermission(AppPaths.SOFTWARE_LICENSE_ADD)) {
                formAction = AppPaths.SOFTWARE_LICENSE_ADD_2;
                showAddLicenseForm = true;
                canDeleteLicense = false;
                if (!actionForm.isResubmit()) {
                    actionForm.setLicense(new SoftwareLicense());
                    actionForm.setLicenseEntitlement("1");
                }
            } else if (cmd.equals("edit")) {
                formAction = AppPaths.SOFTWARE_LICENSE_EDIT_2;
                canDeleteLicense = false;
                SoftwareLicense softwareLicense = softwareService.getSoftwareLicense(actionForm.getSoftwareId(), actionForm.getLicenseId());
                if (!actionForm.isResubmit()) {
                    actionForm.setLicense(softwareLicense);
                }
                formLicenseId = actionForm.getLicenseId();
            }
            ActionErrorsTemplate errorsTemplate = standardTemplate.addTemplate(new ActionErrorsTemplate());
            errorsTemplate.setShowRequiredFieldMsg(true);
        }
        QueryCriteria query = new QueryCriteria();
        query.addSortColumn(SoftwareQueries.getOrderByColumn("license_key"));
        query.addSortColumn("license_id");
        query.addSortColumn(SoftwareQueries.getOrderByColumn("hardware_name"));
        int colSpan = 6;
        List<Map<String, String>> softwareLicenseList = softwareService.getSoftwareLicenses(query, softwareId);
        ArrayList softwareLicenses = new ArrayList();
        if (!softwareLicenseList.isEmpty()) {
            Integer lastLicenseId = 0;
            ArrayList<String> hardwareNameList = null;
            for (Map<String, String> map : softwareLicenseList) {
                String string = map.get("hardware_id");
                Integer currentLicenseId = NumberUtils.replaceNull(map.get("license_id"));
                if (!lastLicenseId.equals(currentLicenseId)) {
                    hardwareNameList = new ArrayList<String>();
                }
                if (string != null) {
                    String hardwareOwnerId;
                    hardwareDetailsLink = new Link(this.requestContext);
                    StringBuilder hardwareOwner = new StringBuilder();
                    hardwareOwner.append(map.get("hardware_name"));
                    if (ConfigManager.app.getSoftwareLicenseColumns().contains("hardware_owner_name") && (hardwareOwnerId = map.get("hardware_owner")) != null) {
                        AccessUser hardwareOwnerUser = new CacheManager(this.requestContext).getUserCache(Integer.valueOf(hardwareOwnerId));
                        hardwareOwner.append(" (").append(Localizer.getText(this.requestContext, "common.column.owner")).append(": ").append(AdminUtils.getSystemUsername(this.requestContext, hardwareOwnerUser) + ")");
                    }
                    hardwareDetailsLink.setTitle(hardwareOwner.toString());
                    if (hasHardwareAccess) {
                        hardwareDetailsLink.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + string);
                    }
                    StringBuilder hardwareName = new StringBuilder();
                    hardwareName.append(hardwareDetailsLink.getString());
                    if (hasHardwareAjaxAccess) {
                        hardwareDetailsLink = new Link(this.requestContext);
                        hardwareDetailsLink.setInlineImage(Image.getInstance().getMagGlassIcon("hardwarePopupAjax.show(this," + string + ")"));
                        hardwareName.append(hardwareDetailsLink.getString());
                    }
                    hardwareNameList.add(hardwareName.toString());
                }
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                if (lastLicenseId.equals(currentLicenseId)) continue;
                lastLicenseId = currentLicenseId;
                map2.put("hardwareNames", hardwareNameList);
                if (canEditLicense) {
                    map2.put("editLink", new Link(this.requestContext).setTitleKey("common.action.Edit").setAjaxPath(editLicensePath + "&licenseId=" + map.get("license_id") + "&cmd=edit").getString());
                }
                map2.put("licenseId", currentLicenseId);
                if (hasLicenseCustomFields) {
                    String onclickScript = "App.toggleCustomFieldsUpdate(this, 'cf" + currentLicenseId + "','" + AppPaths.ROOT + AppPaths.SOFTWARE_AJAX_CUSTOM_FIELDS + "?softwareId=" + softwareId + "&licenseId=" + currentLicenseId + "','" + Localizer.getText(this.requestContext, "common.action.ToggleCollapse") + "', '" + Localizer.getText(this.requestContext, "common.action.ToggleExpand") + "')";
                    Link link = new Link(this.requestContext);
                    link.setInlineImage(Image.getInstance().getExpandIcon(this.requestContext, "common.action.ToggleExpand", "", onclickScript));
                    map2.put("customFieldsLink", link.getString());
                }
                map2.put("licenseKey", HtmlUtils.encode(map.get("license_key")));
                map2.put("licenseEntitlement", map.get("license_entitlement"));
                String licenseNotes = SoftwareUtils.formatLicenseKey(this.requestContext, map.get("license_note"), ConfigManager.app.getSoftwareLicenseNotesNumChars(), currentLicenseId);
                map2.put("licenseNote", licenseNotes);
                softwareLicenses.add(map2);
            }
        } else {
            TableEmptyTemplate empty = standardTemplate.addTemplate(new TableEmptyTemplate());
            empty.setColSpan(colSpan);
            empty.setRowText(Localizer.getText(this.requestContext, "itMgmt.softwareDetail_emptyTableMessage"));
        }
        Counter counter = new Counter();
        query = new QueryCriteria();
        query.addSortColumn(SoftwareQueries.getOrderByColumn("hardware_name"));
        ArrayList softwareNeedLicenseList = new ArrayList();
        List<Map<String, String>> hardwareList = softwareService.getSoftwareLicenseHardwareList(query, softwareId);
        for (Map<String, String> map : hardwareList) {
            HashMap<String, String> map3 = new HashMap<String, String>();
            hardwareDetailsLink = new Link(this.requestContext);
            hardwareDetailsLink.setTitle(map.get("hardware_name"));
            if (hasHardwareAccess) {
                hardwareDetailsLink.setAjaxPath(AppPaths.HARDWARE_DETAIL + "?hardwareId=" + map.get("hardware_id"));
            }
            map3.put("hardwareName", hardwareDetailsLink.getString());
            map3.put("rowNum", String.valueOf(counter.incr()));
            softwareNeedLicenseList.add(map3);
        }
        standardTemplate.setAttribute("softwareId", softwareId);
        standardTemplate.setAttribute("cmd", cmd);
        standardTemplate.setPathAttribute("formAction", formAction);
        standardTemplate.setPathAttribute("ajaxHardwareDetailPath", AppPaths.IT_MGMT_AJAX_GET_HARDWARE_DETAIL + "?hardwareId=");
        standardTemplate.setAttribute("formCancelLink", Links.getCancelLink(this.requestContext, AppPaths.SOFTWARE_DETAIL + "?softwareId=" + softwareId).getString());
        standardTemplate.setAttribute("formLicenseId", formLicenseId);
        standardTemplate.setAttribute("addLicense", showAddLicenseForm);
        standardTemplate.setAttribute("canDeleteLicense", canDeleteLicense);
        standardTemplate.setAttribute("softwareLicenseList", softwareLicenses);
        standardTemplate.setAttribute("softwareNeedLicenseList", softwareNeedLicenseList);
        standardTemplate.setAttribute("colSpan", colSpan);
        SoftwareSpecTemplate softwareSpecTemplate = standardTemplate.addTemplate(new SoftwareSpecTemplate(software));
        softwareSpecTemplate.setPopulateLinkedContract(true);
        CustomFieldsTemplate customFieldsTemplate = standardTemplate.addTemplate(new CustomFieldsTemplate());
        customFieldsTemplate.setObjectTypeId(ObjectTypes.SOFTWARE);
        customFieldsTemplate.setObjectId(softwareId);
        customFieldsTemplate.setObjectAttrTypeId(software.getType());
        customFieldsTemplate.setShowDefaultHeader(false);
        SoftwareUtils.addSoftwareHeaderCommands(this.requestContext, header, softwareId);
        if (accessUser.hasPermission(AppPaths.SOFTWARE_LICENSE_ADD)) {
            Link link = new Link(this.requestContext);
            link.setAjaxPath(hasLicenseCustomFields ? AppPaths.SOFTWARE_LICENSE_ADD + "?softwareId=" + softwareId : AppPaths.SOFTWARE_DETAIL + "?softwareId=" + softwareId + "&cmd=add");
            link.setTitleKey("itMgmt.cmd.softwareLicenseAdd");
            header.addHeaderCmds(link);
        }
        header.setPageTitleKey("itMgmt.softwareDetail.header", new Object[]{software.getName()});
        TabsTemplate tabs = standardTemplate.addTemplate(new TabsTemplate());
        tabs.setTabList(SoftwareUtils.getSoftwareTabs(this.requestContext, software));
        tabs.setTabActive("detailsTab");
        return standardTemplate.findTemplate("standard_template");
    }
}

